/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.formula;

import java.util.Arrays;
import java.util.List;
import org.epics.pvmanager.formula.FormulaFunction;
import org.epics.vtype.Alarm;
import org.epics.vtype.Display;
import org.epics.vtype.Time;
import org.epics.vtype.VNumber;
import org.epics.vtype.ValueFactory;

abstract class OneArgNumericFormulaFunction
implements FormulaFunction {
    private final String name;
    private final String description;
    private final List<Class<?>> argumentTypes;
    private final List<String> argumentNames;

    public OneArgNumericFormulaFunction(String name, String description, String argName) {
        this.name = name;
        this.description = description;
        this.argumentTypes = Arrays.asList(VNumber.class);
        this.argumentNames = Arrays.asList(argName);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isPure() {
        return true;
    }

    @Override
    public boolean isVarArgs() {
        return false;
    }

    @Override
    public List<Class<?>> getArgumentTypes() {
        return this.argumentTypes;
    }

    @Override
    public List<String> getArgumentNames() {
        return this.argumentNames;
    }

    @Override
    public Class<?> getReturnType() {
        return VNumber.class;
    }

    @Override
    public Object calculate(List<Object> args) {
        VNumber arg = (VNumber)args.get(0);
        if (arg == null) {
            return null;
        }
        return ValueFactory.newVDouble((Double)this.calculate(arg.getValue().doubleValue()), (Alarm)arg, (Time)arg, (Display)ValueFactory.displayNone());
    }

    abstract double calculate(double var1);
}

