/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.formula;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.epics.pvmanager.expression.DesiredRateExpression;
import org.epics.pvmanager.formula.DynamicFormulaFunction;
import org.epics.pvmanager.formula.LastOfChannelExpression;
import org.epics.vtype.VString;

class PvFormulaFunction
extends DynamicFormulaFunction {
    private String previousName;
    private DesiredRateExpression<?> currentExpression;

    PvFormulaFunction() {
    }

    @Override
    public boolean isVarArgs() {
        return false;
    }

    @Override
    public String getName() {
        return "pv";
    }

    @Override
    public String getDescription() {
        return "Returns the value of the given pv name";
    }

    @Override
    public List<Class<?>> getArgumentTypes() {
        return Arrays.asList(VString.class);
    }

    @Override
    public List<String> getArgumentNames() {
        return Arrays.asList("pvName");
    }

    @Override
    public Class<?> getReturnType() {
        return Object.class;
    }

    @Override
    public Object calculate(List<Object> args) {
        VString value = (VString)args.get(0);
        String newName = null;
        if (value != null) {
            newName = value.getValue();
        }
        if (!Objects.equals(newName, this.previousName)) {
            if (this.currentExpression != null) {
                this.getDirector().disconnectExpression(this.currentExpression);
                this.currentExpression = null;
            }
            if (newName != null) {
                this.currentExpression = new LastOfChannelExpression<Object>(newName, Object.class);
                this.getDirector().connectExpression(this.currentExpression);
            }
            this.previousName = newName;
        }
        if (newName == null) {
            return null;
        }
        return this.currentExpression.getFunction().readValue();
    }

    @Override
    public void dispose() {
        this.getDirector().disconnectExpression(this.currentExpression);
        this.currentExpression = null;
    }
}

