/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.formula;

import java.util.Arrays;
import java.util.List;
import org.epics.pvmanager.formula.FormulaFunction;
import org.epics.vtype.VNumber;
import org.epics.vtype.table.ListNumberProvider;
import org.epics.vtype.table.VTableFactory;

class RangeFormulaFunction
implements FormulaFunction {
    RangeFormulaFunction() {
    }

    @Override
    public boolean isPure() {
        return true;
    }

    @Override
    public boolean isVarArgs() {
        return false;
    }

    @Override
    public String getName() {
        return "range";
    }

    @Override
    public String getDescription() {
        return "A generator for values between a range";
    }

    @Override
    public List<Class<?>> getArgumentTypes() {
        return Arrays.asList(VNumber.class, VNumber.class);
    }

    @Override
    public List<String> getArgumentNames() {
        return Arrays.asList("minValue", "maxValue");
    }

    @Override
    public Class<?> getReturnType() {
        return ListNumberProvider.class;
    }

    @Override
    public Object calculate(List<Object> args) {
        VNumber minValue = (VNumber)args.get(0);
        VNumber maxValue = (VNumber)args.get(1);
        if (minValue == null || maxValue == null) {
            return null;
        }
        return VTableFactory.range((double)minValue.getValue().doubleValue(), (double)maxValue.getValue().doubleValue());
    }
}

