/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.formula;

import java.util.Arrays;
import java.util.List;
import org.epics.pvmanager.formula.FormulaFunction;
import org.epics.pvmanager.util.NullUtils;
import org.epics.util.array.ListMath;
import org.epics.util.array.ListNumber;
import org.epics.vtype.Alarm;
import org.epics.vtype.Display;
import org.epics.vtype.Time;
import org.epics.vtype.VNumber;
import org.epics.vtype.VNumberArray;
import org.epics.vtype.ValueFactory;
import org.epics.vtype.ValueUtil;

class RescaleArrayFormulaFunction
implements FormulaFunction {
    RescaleArrayFormulaFunction() {
    }

    @Override
    public boolean isPure() {
        return true;
    }

    @Override
    public boolean isVarArgs() {
        return true;
    }

    @Override
    public String getName() {
        return "rescale";
    }

    @Override
    public String getDescription() {
        return "Rescale an array using the factor and offset";
    }

    @Override
    public List<Class<?>> getArgumentTypes() {
        return Arrays.asList(VNumberArray.class, VNumber.class, VNumber.class);
    }

    @Override
    public List<String> getArgumentNames() {
        return Arrays.asList("array", "factor", "offset");
    }

    @Override
    public Class<?> getReturnType() {
        return VNumberArray.class;
    }

    @Override
    public Object calculate(List<Object> args) {
        if (NullUtils.containsNull(args)) {
            return null;
        }
        VNumberArray arg1 = (VNumberArray)args.get(0);
        VNumber arg2 = (VNumber)args.get(1);
        VNumber arg3 = (VNumber)args.get(2);
        return ValueFactory.newVNumberArray((ListNumber)ListMath.rescale((ListNumber)arg1.getData(), (double)arg2.getValue().doubleValue(), (double)arg3.getValue().doubleValue()), (Alarm)ValueUtil.highestSeverityOf(args, (boolean)false), (Time)ValueUtil.latestValidTimeOrNowOf(args), (Display)ValueFactory.displayNone());
    }
}

