/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.formula;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.epics.pvmanager.formula.FormulaFunction;
import org.epics.vtype.VTable;
import org.epics.vtype.table.Column;
import org.epics.vtype.table.VTableFactory;

class TableOfFormulaFunction
implements FormulaFunction {
    TableOfFormulaFunction() {
    }

    @Override
    public boolean isPure() {
        return true;
    }

    @Override
    public boolean isVarArgs() {
        return true;
    }

    @Override
    public String getName() {
        return "tableOf";
    }

    @Override
    public String getDescription() {
        return "Constructs a table from a series of columns";
    }

    @Override
    public List<Class<?>> getArgumentTypes() {
        return Arrays.asList(Column.class);
    }

    @Override
    public List<String> getArgumentNames() {
        return Arrays.asList("columns");
    }

    @Override
    public Class<?> getReturnType() {
        return VTable.class;
    }

    @Override
    public Object calculate(List<Object> args) {
        ArrayList<Object> argsNoNull = new ArrayList<Object>(args);
        boolean removedNull = false;
        while (argsNoNull.remove(null)) {
            removedNull = true;
        }
        if (removedNull) {
            boolean allGenerated = true;
            for (Object e : argsNoNull) {
                Column column = (Column)e;
                if (column.isGenerated()) continue;
                allGenerated = false;
            }
            if (allGenerated) {
                return null;
            }
        }
        Column[] columns = argsNoNull.toArray(new Column[argsNoNull.size()]);
        return VTableFactory.newVTable((Column[])columns);
    }
}

