/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.formula;

import java.util.Arrays;
import java.util.List;
import org.epics.pvmanager.formula.FormulaFunction;
import org.epics.vtype.VString;
import org.epics.vtype.VTable;
import org.epics.vtype.VType;
import org.epics.vtype.table.VTableFactory;

class TableRangeFilterFunction
implements FormulaFunction {
    TableRangeFilterFunction() {
    }

    @Override
    public boolean isPure() {
        return true;
    }

    @Override
    public boolean isVarArgs() {
        return false;
    }

    @Override
    public String getName() {
        return "tableRangeFilter";
    }

    @Override
    public String getDescription() {
        return "Extract the rows where the column value is within the range [min, max)";
    }

    @Override
    public List<Class<?>> getArgumentTypes() {
        return Arrays.asList(VTable.class, VString.class, VType.class, VType.class);
    }

    @Override
    public List<String> getArgumentNames() {
        return Arrays.asList("table", "columName", "min", "max");
    }

    @Override
    public Class<?> getReturnType() {
        return VTable.class;
    }

    @Override
    public Object calculate(List<Object> args) {
        VTable table = (VTable)args.get(0);
        VString columnName = (VString)args.get(1);
        VType min = (VType)args.get(2);
        VType max = (VType)args.get(3);
        if (columnName == null || columnName.getValue() == null || table == null || min == null || max == null) {
            return null;
        }
        VTable result = VTableFactory.tableRangeFilter((VTable)table, (String)columnName.getValue(), (Object)min, (Object)max);
        return result;
    }
}

