/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.formula;

import java.util.Arrays;
import java.util.List;
import org.epics.pvmanager.formula.FormulaFunction;
import org.epics.vtype.Alarm;
import org.epics.vtype.Time;
import org.epics.vtype.VType;
import org.epics.vtype.ValueFactory;
import org.epics.vtype.ValueUtil;

class ToStringFunction
implements FormulaFunction {
    ToStringFunction() {
    }

    @Override
    public boolean isPure() {
        return true;
    }

    @Override
    public boolean isVarArgs() {
        return true;
    }

    @Override
    public String getName() {
        return "toString";
    }

    @Override
    public String getDescription() {
        return "Convert the value to a string";
    }

    @Override
    public List<Class<?>> getArgumentTypes() {
        return Arrays.asList(VType.class);
    }

    @Override
    public List<String> getArgumentNames() {
        return Arrays.asList("value");
    }

    @Override
    public Class<?> getReturnType() {
        return VType.class;
    }

    @Override
    public Object calculate(List<Object> args) {
        Time time;
        VType value = (VType)args.get(0);
        Alarm alarm = ValueUtil.alarmOf((Object)value);
        if (alarm == null) {
            alarm = ValueFactory.alarmNone();
        }
        if ((time = ValueUtil.timeOf((Object)value)) == null) {
            time = ValueFactory.timeNow();
        }
        return ValueFactory.newVString((String)ValueUtil.getDefaultValueFormat().format((Object)value), (Alarm)alarm, (Time)time);
    }
}

