/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.extra;

import java.awt.Color;
import java.util.Random;
import org.epics.vtype.Display;
import org.epics.vtype.ValueUtil;

public abstract class ColorScheme {
    public abstract int color(double var1, Display var3);

    public static ColorScheme singleRangeGradient(Color minValueColor, Color maxValueColor) {
        return ColorScheme.singleRangeGradient(minValueColor, maxValueColor, Color.BLACK);
    }

    public static ColorScheme singleRangeGradient(final Color minValueColor, final Color maxValueColor, final Color nanColor) {
        return new ColorScheme(){
            Random rand = new Random();

            @Override
            public int color(double value, Display ranges) {
                if (Double.isNaN(value)) {
                    return nanColor.getRGB();
                }
                double normalValue = ValueUtil.normalize((Number)value, (Display)ranges);
                normalValue = Math.min(normalValue, 1.0);
                normalValue = Math.max(normalValue, 0.0);
                int alpha = 255;
                int red = (int)((double)minValueColor.getRed() + (double)(maxValueColor.getRed() - minValueColor.getRed()) * normalValue);
                int green = (int)((double)minValueColor.getGreen() + (double)(maxValueColor.getGreen() - minValueColor.getGreen()) * normalValue);
                int blue = (int)((double)minValueColor.getBlue() + (double)(maxValueColor.getBlue() - minValueColor.getBlue()) * normalValue);
                return alpha << 24 | red << 16 | green << 8 | blue;
            }
        };
    }

    public static ColorScheme multipleRangeGradient(final Color lowerDisplayColor, final Color lowerAlarmColor, final Color lowerWarningColor, final Color upperWarningColor, final Color upperAlarmColor, final Color upperDisplayColor) {
        return new ColorScheme(){
            Random rand = new Random();

            @Override
            public int color(double value, Display ranges) {
                if (Double.isNaN(value)) {
                    return 0;
                }
                double normalValue = 0.0;
                Color minValueColor = null;
                Color maxValueColor = null;
                if (value < ranges.getLowerDisplayLimit()) {
                    return lowerDisplayColor.getRGB();
                }
                if (value < ranges.getLowerAlarmLimit()) {
                    normalValue = ValueUtil.normalize((Number)value, (Number)ranges.getLowerDisplayLimit(), (Number)ranges.getLowerAlarmLimit());
                    minValueColor = lowerDisplayColor;
                    maxValueColor = lowerAlarmColor;
                } else if (value < ranges.getLowerWarningLimit()) {
                    normalValue = ValueUtil.normalize((Number)value, (Number)ranges.getLowerAlarmLimit(), (Number)ranges.getLowerWarningLimit());
                    minValueColor = lowerAlarmColor;
                    maxValueColor = lowerWarningColor;
                } else if (value <= ranges.getUpperWarningLimit()) {
                    normalValue = ValueUtil.normalize((Number)value, (Number)ranges.getLowerWarningLimit(), (Number)ranges.getUpperWarningLimit());
                    minValueColor = lowerWarningColor;
                    maxValueColor = upperWarningColor;
                } else if (value <= ranges.getUpperAlarmLimit()) {
                    normalValue = ValueUtil.normalize((Number)value, (Number)ranges.getUpperWarningLimit(), (Number)ranges.getUpperAlarmLimit());
                    minValueColor = upperWarningColor;
                    maxValueColor = upperAlarmColor;
                } else {
                    return upperDisplayColor.getRGB();
                }
                int alpha = 255;
                int red = (int)((double)minValueColor.getRed() + (double)(maxValueColor.getRed() - minValueColor.getRed()) * normalValue);
                int green = (int)((double)minValueColor.getGreen() + (double)(maxValueColor.getGreen() - minValueColor.getGreen()) * normalValue);
                int blue = (int)((double)minValueColor.getBlue() + (double)(maxValueColor.getBlue() - minValueColor.getBlue()) * normalValue);
                return alpha << 24 | red << 16 | green << 8 | blue;
            }
        };
    }
}

