/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.extra;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;
import org.epics.pvmanager.ReadFunction;
import org.epics.pvmanager.extra.DoubleArrayTimeCache;
import org.epics.util.array.ListNumber;
import org.epics.util.time.Timestamp;
import org.epics.vtype.Display;
import org.epics.vtype.VNumberArray;

public class DoubleArrayTimeCacheFromVDoubleArray
implements DoubleArrayTimeCache {
    private NavigableMap<Timestamp, VNumberArray> cache = new TreeMap<Timestamp, VNumberArray>();
    private ReadFunction<? extends List<? extends VNumberArray>> function;
    private Display display;

    public DoubleArrayTimeCacheFromVDoubleArray(ReadFunction<? extends List<? extends VNumberArray>> function) {
        this.function = function;
    }

    private void deleteBefore(Timestamp timeStamp) {
        if (this.cache.isEmpty()) {
            return;
        }
        Timestamp firstEntryBeforeTimestamp = this.cache.lowerKey(timeStamp);
        if (firstEntryBeforeTimestamp == null) {
            return;
        }
        Timestamp lastToDelete = this.cache.lowerKey(firstEntryBeforeTimestamp);
        if (lastToDelete == null) {
            return;
        }
        Timestamp firstKey = (Timestamp)this.cache.firstKey();
        while (firstKey.compareTo(lastToDelete) <= 0) {
            this.cache.remove(firstKey);
            firstKey = (Timestamp)this.cache.firstKey();
        }
    }

    @Override
    public DoubleArrayTimeCache.Data getData(Timestamp begin, Timestamp end) {
        List newValues = (List)this.function.readValue();
        for (VNumberArray value : newValues) {
            this.cache.put(value.getTimestamp(), value);
        }
        if (this.cache.isEmpty()) {
            return null;
        }
        Timestamp newBegin = this.cache.lowerKey(begin);
        if (newBegin == null) {
            newBegin = (Timestamp)this.cache.firstKey();
        }
        this.deleteBefore(begin);
        return this.data(newBegin, end);
    }

    private DoubleArrayTimeCache.Data data(Timestamp begin, Timestamp end) {
        return new Data(this.cache.subMap(begin, end), begin, end);
    }

    @Override
    public List<DoubleArrayTimeCache.Data> newData(Timestamp beginUpdate, Timestamp endUpdate, Timestamp beginNew, Timestamp endNew) {
        Timestamp firstNewValue;
        List newValues = (List)this.function.readValue();
        if (newValues.isEmpty()) {
            return Collections.singletonList(this.data(this.cache.lowerKey(endNew), endNew));
        }
        ArrayList<Timestamp> newTimestamps = new ArrayList<Timestamp>();
        for (VNumberArray value : newValues) {
            this.cache.put(value.getTimestamp(), value);
            newTimestamps.add(value.getTimestamp());
        }
        if (this.cache.isEmpty()) {
            return Collections.emptyList();
        }
        Collections.sort(newTimestamps);
        Timestamp newBegin = firstNewValue = (Timestamp)newTimestamps.get(0);
        if (firstNewValue.compareTo(beginUpdate) < 0) {
            newBegin = beginUpdate;
        }
        if (firstNewValue.compareTo(beginNew) > 0) {
            newBegin = beginNew;
        }
        if ((newBegin = this.cache.lowerKey(newBegin)) == null) {
            newBegin = (Timestamp)this.cache.firstKey();
        }
        this.deleteBefore(beginUpdate);
        return Collections.singletonList(this.data(newBegin, endNew));
    }

    @Override
    public Display getDisplay() {
        if (this.display == null) {
            this.display = (Display)this.cache.firstEntry().getValue();
        }
        return this.display;
    }

    public class Data
    implements DoubleArrayTimeCache.Data {
        private List<Timestamp> times = new ArrayList<Timestamp>();
        private List<ListNumber> arrays = new ArrayList<ListNumber>();
        private Timestamp begin;
        private Timestamp end;

        private Data(SortedMap<Timestamp, VNumberArray> subMap, Timestamp begin, Timestamp end) {
            this.begin = begin;
            this.end = end;
            for (Map.Entry<Timestamp, VNumberArray> en : subMap.entrySet()) {
                this.times.add(en.getKey());
                this.arrays.add(en.getValue().getData());
            }
        }

        @Override
        public Timestamp getBegin() {
            return this.begin;
        }

        @Override
        public Timestamp getEnd() {
            return this.end;
        }

        @Override
        public int getNArrays() {
            return this.times.size();
        }

        @Override
        public ListNumber getArray(int index) {
            return this.arrays.get(index);
        }

        @Override
        public Timestamp getTimestamp(int index) {
            return this.times.get(index);
        }
    }
}

