/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.formula;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.epics.pvmanager.formula.FormulaFunction;
import org.epics.vtype.Alarm;
import org.epics.vtype.Time;
import org.epics.vtype.VString;
import org.epics.vtype.VStringArray;
import org.epics.vtype.ValueFactory;
import org.epics.vtype.ValueUtil;

class ArrayOfStringFormulaFunction
implements FormulaFunction {
    ArrayOfStringFormulaFunction() {
    }

    @Override
    public boolean isPure() {
        return true;
    }

    @Override
    public boolean isVarArgs() {
        return true;
    }

    @Override
    public String getName() {
        return "arrayOf";
    }

    @Override
    public String getDescription() {
        return "Constructs array from a series of string";
    }

    @Override
    public List<Class<?>> getArgumentTypes() {
        return Arrays.asList(VString.class);
    }

    @Override
    public List<String> getArgumentNames() {
        return Arrays.asList("strArgs");
    }

    @Override
    public Class<?> getReturnType() {
        return VStringArray.class;
    }

    @Override
    public Object calculate(List<Object> args) {
        ArrayList<String> data = new ArrayList<String>();
        for (Object arg : args) {
            VString str = (VString)arg;
            if (str == null || str.getValue() == null) {
                data.add(null);
                continue;
            }
            data.add(str.getValue());
        }
        return ValueFactory.newVStringArray(data, (Alarm)ValueUtil.highestSeverityOf(args, (boolean)false), (Time)ValueUtil.latestValidTimeOrNowOf(args));
    }
}

