/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.formula;

import java.util.Arrays;
import java.util.List;
import org.epics.pvmanager.formula.FormulaFunction;
import org.epics.pvmanager.util.NullUtils;
import org.epics.vtype.Alarm;
import org.epics.vtype.Display;
import org.epics.vtype.Time;
import org.epics.vtype.VEnum;
import org.epics.vtype.VNumber;
import org.epics.vtype.ValueFactory;
import org.epics.vtype.ValueUtil;

class EnumIndexOfFunction
implements FormulaFunction {
    EnumIndexOfFunction() {
    }

    @Override
    public boolean isPure() {
        return true;
    }

    @Override
    public boolean isVarArgs() {
        return false;
    }

    @Override
    public String getName() {
        return "indexOf";
    }

    @Override
    public String getDescription() {
        return "Gets the index of a VEnum";
    }

    @Override
    public List<Class<?>> getArgumentTypes() {
        return Arrays.asList(VEnum.class);
    }

    @Override
    public List<String> getArgumentNames() {
        return Arrays.asList("enum");
    }

    @Override
    public Class<?> getReturnType() {
        return VNumber.class;
    }

    @Override
    public Object calculate(List<Object> args) {
        if (NullUtils.containsNull(args)) {
            return null;
        }
        VEnum value = (VEnum)args.get(0);
        return ValueFactory.newVInt((Integer)value.getIndex(), (Alarm)ValueUtil.highestSeverityOf(args, (boolean)false), (Time)ValueUtil.latestValidTimeOrNowOf(args), (Display)ValueFactory.displayNone());
    }
}

