/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.formula;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.regex.Pattern;
import org.epics.pvmanager.formula.FormulaFunction;
import org.epics.pvmanager.formula.FormulaFunctionSetDescription;

public class FormulaFunctionSet {
    static Pattern namePattern = Pattern.compile("[a-zA-Z_]\\w*");
    private String name;
    private String description;
    private Collection<FormulaFunction> formulaFunctions;

    public FormulaFunctionSet(FormulaFunctionSetDescription functionSetDescription) {
        this.name = functionSetDescription.name;
        this.description = functionSetDescription.description;
        this.formulaFunctions = Collections.unmodifiableSet(new HashSet<FormulaFunction>(functionSetDescription.formulaFunctions));
    }

    public final String getName() {
        return this.name;
    }

    public final String getDescription() {
        return this.description;
    }

    public final Collection<String> getFunctionNames() {
        HashSet<String> names = new HashSet<String>();
        for (FormulaFunction formulaFunction : this.formulaFunctions) {
            names.add(formulaFunction.getName());
        }
        return names;
    }

    public final Collection<FormulaFunction> findFunctions(String name) {
        if (name == null) {
            return Collections.emptyList();
        }
        HashSet<FormulaFunction> formulas = new HashSet<FormulaFunction>();
        for (FormulaFunction formulaFunction : this.formulaFunctions) {
            if (!name.equals(formulaFunction.getName())) continue;
            formulas.add(formulaFunction);
        }
        return formulas;
    }

    public final Collection<FormulaFunction> getFunctions() {
        return this.formulaFunctions;
    }
}

