/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.formula;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.epics.pvmanager.formula.FormulaFunction;
import org.epics.pvmanager.formula.StatefulFormulaFunction;

public class FormulaFunctions {
    private static final Pattern postfixTwoArg = Pattern.compile("\\+|-|\\*|/|%|\\^|\\*\\*|<=|>=|<|>|==|!=|\\|\\||&&|\\||&");
    private static final Pattern prefixOneArg = Pattern.compile("-|!");

    public static boolean matchArgumentTypes(List<Object> arguments, FormulaFunction function) {
        return FormulaFunctions.matchArgumentTypes(arguments, function, false);
    }

    public static boolean matchArgumentTypes(List<Object> arguments, FormulaFunction function, boolean allowNull) {
        List<Class<?>> types = function.getArgumentTypes();
        if (!FormulaFunctions.matchArgumentCount(arguments.size(), function)) {
            return false;
        }
        for (int i = 0; i < arguments.size(); ++i) {
            int j = Math.min(i, types.size() - 1);
            if (types.get(j).isInstance(arguments.get(i)) || allowNull && arguments.get(i) == null) continue;
            return false;
        }
        return true;
    }

    public static boolean matchArgumentCount(int nArguments, FormulaFunction function) {
        if (!function.isVarArgs() && function.getArgumentTypes().size() != nArguments) {
            return false;
        }
        return !function.isVarArgs() || function.getArgumentTypes().size() - 1 <= nArguments;
    }

    public static FormulaFunction findFirstMatch(List<Object> arguments, Collection<FormulaFunction> formulaFunctions) {
        for (FormulaFunction formulaFunction : formulaFunctions) {
            if (!FormulaFunctions.matchArgumentTypes(arguments, formulaFunction, true)) continue;
            return formulaFunction;
        }
        return null;
    }

    public static Collection<FormulaFunction> findArgTypeMatch(List<Class<?>> argTypes, Collection<FormulaFunction> formulaFunctions) {
        HashSet<FormulaFunction> functions = new HashSet<FormulaFunction>();
        for (FormulaFunction formulaFunction : formulaFunctions) {
            if (!formulaFunction.getArgumentTypes().equals(argTypes)) continue;
            functions.add(formulaFunction);
        }
        return functions;
    }

    public static String formatSignature(FormulaFunction function) {
        ArrayList<String> arguments = new ArrayList<String>();
        for (int i = 0; i < function.getArgumentTypes().size() - 1; ++i) {
            arguments.add(function.getArgumentTypes().get(i).getSimpleName() + " " + function.getArgumentNames().get(i));
        }
        StringBuilder lastArgument = new StringBuilder();
        lastArgument.append(function.getArgumentTypes().get(function.getArgumentTypes().size() - 1).getSimpleName());
        if (function.isVarArgs()) {
            lastArgument.append("...");
        }
        lastArgument.append(" ").append(function.getArgumentNames().get(function.getArgumentTypes().size() - 1));
        arguments.add(lastArgument.toString());
        StringBuilder sb = new StringBuilder();
        sb.append(FormulaFunctions.format(function.getName(), arguments));
        sb.append(": ");
        sb.append(function.getReturnType().getSimpleName());
        return sb.toString();
    }

    public static String format(String function, List<String> args) {
        if (args.size() == 3 && "?:".equals(function)) {
            return FormulaFunctions.conditionalOperator(function, args);
        }
        if (args.size() == 2 && postfixTwoArg.matcher(function).matches()) {
            return FormulaFunctions.formatPostfixTwoArgs(function, args);
        }
        if (args.size() == 1 && prefixOneArg.matcher(function).matches()) {
            return FormulaFunctions.formatPrefixOneArg(function, args);
        }
        return FormulaFunctions.formatFunction(function, args);
    }

    private static String conditionalOperator(String function, List<String> args) {
        StringBuilder sb = new StringBuilder();
        sb.append("(").append(args.get(0)).append(" ? ").append(args.get(1)).append(" : ").append(args.get(2)).append(")");
        return sb.toString();
    }

    private static String formatPostfixTwoArgs(String function, List<String> args) {
        StringBuilder sb = new StringBuilder();
        sb.append("(").append(args.get(0)).append(" ").append(function).append(" ").append(args.get(1)).append(")");
        return sb.toString();
    }

    private static String formatPrefixOneArg(String function, List<String> args) {
        StringBuilder sb = new StringBuilder();
        sb.append(function).append(args.get(0));
        return sb.toString();
    }

    private static String formatFunction(String function, List<String> args) {
        StringBuilder sb = new StringBuilder();
        sb.append(function).append('(');
        boolean first = true;
        for (String arg : args) {
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            sb.append(arg);
        }
        sb.append(')');
        return sb.toString();
    }

    static StatefulFormulaFunction createInstance(StatefulFormulaFunction function) {
        try {
            return (StatefulFormulaFunction)function.getClass().newInstance();
        }
        catch (InstantiationException ex) {
            Logger.getLogger(FormulaFunctions.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException("StatefulFormulaFunction " + FormulaFunctions.formatSignature(function) + " must have a no arg constructor.", ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(FormulaFunctions.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException("StatefulFormulaFunction " + FormulaFunctions.formatSignature(function) + " no arg constructor is not accessible.", ex);
        }
    }
}

