/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.formula;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.epics.pvmanager.PVDirector;
import org.epics.pvmanager.ReadFunction;
import org.epics.pvmanager.formula.DynamicFormulaFunction;
import org.epics.pvmanager.formula.FormulaFunction;
import org.epics.pvmanager.formula.FormulaFunctions;
import org.epics.pvmanager.formula.StatefulFormulaFunction;
import org.epics.vtype.ValueUtil;

class FormulaReadFunction
implements ReadFunction<Object> {
    public final List<ReadFunction<?>> argumentFunctions;
    public final Collection<FormulaFunction> formulaMatches;
    public final List<Object> argumentValues;
    public final String functionName;
    public FormulaFunction lastFormula;
    public Object lastValue;
    public volatile PVDirector<?> director;

    FormulaReadFunction(List<ReadFunction<?>> argumentFunctions, Collection<FormulaFunction> formulaMatches) {
        this.argumentFunctions = argumentFunctions;
        this.formulaMatches = formulaMatches;
        this.argumentValues = new ArrayList<Object>(argumentFunctions.size());
        for (ReadFunction<?> argumentFunction : argumentFunctions) {
            this.argumentValues.add(null);
        }
        this.functionName = formulaMatches.iterator().next().getName();
    }

    void setDirector(PVDirector<?> director) {
        this.director = director;
    }

    public Object readValue() {
        ArrayList<Object> previousValues = new ArrayList<Object>(this.argumentValues);
        for (int i = 0; i < this.argumentFunctions.size(); ++i) {
            this.argumentValues.set(i, this.argumentFunctions.get(i).readValue());
        }
        if (previousValues.equals(this.argumentValues) && this.lastFormula != null && this.lastFormula.isPure()) {
            return this.lastValue;
        }
        if (this.lastFormula == null || !FormulaFunctions.matchArgumentTypes(this.argumentValues, this.lastFormula)) {
            if (this.lastFormula instanceof StatefulFormulaFunction) {
                ((StatefulFormulaFunction)this.lastFormula).dispose();
            }
            this.lastFormula = FormulaFunctions.findFirstMatch(this.argumentValues, this.formulaMatches);
            if (this.lastFormula instanceof StatefulFormulaFunction) {
                this.lastFormula = FormulaFunctions.createInstance((StatefulFormulaFunction)this.lastFormula);
            }
            if (this.lastFormula instanceof DynamicFormulaFunction) {
                ((DynamicFormulaFunction)this.lastFormula).setDirector(this.director);
            }
        }
        if (this.lastFormula == null) {
            ArrayList<String> typeNames = new ArrayList<String>(this.argumentValues.size());
            for (Object object : this.argumentValues) {
                Class<?> clazz = ValueUtil.typeOf((Object)object);
                if (Object.class.equals((Object)clazz)) {
                    clazz = object.getClass();
                }
                if (clazz != null) {
                    typeNames.add(clazz.getSimpleName());
                    continue;
                }
                typeNames.add("null");
            }
            throw new RuntimeException("Can't find match for function '" + this.functionName + "'  and arguments " + typeNames);
        }
        this.lastValue = this.lastFormula.calculate(this.argumentValues);
        return this.lastValue;
    }
}

