/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.formula;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.epics.pvmanager.formula.StatefulFormulaFunction;
import org.epics.util.time.TimeDuration;
import org.epics.util.time.Timestamp;
import org.epics.vtype.VNumber;
import org.epics.vtype.ValueFactory;

class IntegrateFormulaFunction
extends StatefulFormulaFunction {
    private Timestamp previousTime;
    private double integratedValue;
    private List<VNumber> values = new LinkedList<VNumber>();

    IntegrateFormulaFunction() {
    }

    @Override
    public boolean isVarArgs() {
        return false;
    }

    @Override
    public String getName() {
        return "integrate";
    }

    @Override
    public String getDescription() {
        return "Integrates the given signal in time";
    }

    @Override
    public List<Class<?>> getArgumentTypes() {
        return Arrays.asList(VNumber.class);
    }

    @Override
    public List<String> getArgumentNames() {
        return Arrays.asList("value");
    }

    @Override
    public Class<?> getReturnType() {
        return VNumber.class;
    }

    @Override
    public Object calculate(List<Object> args) {
        VNumber value = (VNumber)args.get(0);
        if (value != null && value.getValue() != null) {
            this.values.add(value);
        }
        if (this.values.isEmpty()) {
            return null;
        }
        if (this.previousTime == null) {
            Timestamp now = Timestamp.now();
            this.previousTime = now.compareTo(this.values.get(0).getTimestamp()) <= 0 ? now : this.values.get(0).getTimestamp();
        }
        Timestamp currentTime = Timestamp.now();
        this.integratedValue += IntegrateFormulaFunction.integrate(this.previousTime, currentTime, this.values);
        this.previousTime = currentTime;
        while (this.values.size() > 1 && this.values.get(1).getTimestamp().compareTo(currentTime) <= 0) {
            this.values.remove(0);
        }
        return ValueFactory.newVDouble((Double)this.integratedValue);
    }

    static double integrate(Timestamp start, Timestamp end, List<VNumber> values) {
        if (values.isEmpty()) {
            return 0.0;
        }
        if (values.get(0).getTimestamp().compareTo(end) >= 0) {
            return 0.0;
        }
        double integratedValue = 0.0;
        for (int i = 0; i < values.size() - 1; ++i) {
            integratedValue += IntegrateFormulaFunction.integrate(start, end, values.get(i), values.get(i + 1));
        }
        return integratedValue += IntegrateFormulaFunction.integrate(start, end, values.get(values.size() - 1), null);
    }

    static double integrate(Timestamp start, Timestamp end, VNumber value, VNumber nextValue) {
        TimeDuration duration;
        Timestamp actualStart = Collections.max(Arrays.asList(start, value.getTimestamp()));
        Timestamp actualEnd = end;
        if (nextValue != null) {
            actualEnd = Collections.min(Arrays.asList(end, nextValue.getTimestamp()));
        }
        if ((duration = actualEnd.durationFrom(actualStart)).isPositive()) {
            return duration.toSeconds() * value.getValue().doubleValue();
        }
        return 0.0;
    }
}

