/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.formula;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.epics.pvmanager.expression.DesiredRateExpression;
import org.epics.pvmanager.formula.DynamicFormulaFunction;
import org.epics.pvmanager.formula.LastOfChannelExpression;
import org.epics.vtype.VStringArray;
import org.epics.vtype.VTable;
import org.epics.vtype.VType;
import org.epics.vtype.table.VTableFactory;

class PvsFormulaFunction
extends DynamicFormulaFunction {
    private List<String> previousNames;
    private List<DesiredRateExpression<?>> currentExpressions;

    PvsFormulaFunction() {
    }

    @Override
    public boolean isVarArgs() {
        return false;
    }

    @Override
    public String getName() {
        return "pvs";
    }

    @Override
    public String getDescription() {
        return "Returns a table with the values of the given pv names";
    }

    @Override
    public List<Class<?>> getArgumentTypes() {
        return Arrays.asList(VStringArray.class);
    }

    @Override
    public List<String> getArgumentNames() {
        return Arrays.asList("pvNames");
    }

    @Override
    public Class<?> getReturnType() {
        return VTable.class;
    }

    Object calculateImpl(List<String> newNames) {
        if (!Objects.equals(newNames, this.previousNames)) {
            ArrayList newExpressions = new ArrayList();
            if (newNames != null) {
                newExpressions.addAll(Collections.nCopies(newNames.size(), null));
            }
            if (this.previousNames != null) {
                if (newNames != null) {
                    for (int previousIndex = 0; previousIndex < this.previousNames.size(); ++previousIndex) {
                        int newIndex = newNames.indexOf(this.previousNames.get(previousIndex));
                        if (newIndex == -1) continue;
                        newExpressions.set(newIndex, this.currentExpressions.get(previousIndex));
                        this.currentExpressions.set(previousIndex, null);
                    }
                }
                for (DesiredRateExpression<?> desiredRateExpression : this.currentExpressions) {
                    if (desiredRateExpression == null) continue;
                    this.getDirector().disconnectReadExpression(desiredRateExpression);
                }
            }
            if (newNames != null) {
                for (int i = 0; i < newNames.size(); ++i) {
                    if (newNames.get(i) == null || newExpressions.get(i) != null) continue;
                    LastOfChannelExpression<Object> newExpression = new LastOfChannelExpression<Object>(newNames.get(i), Object.class);
                    this.getDirector().connectReadExpression(newExpression);
                    newExpressions.set(i, newExpression);
                }
            }
            this.previousNames = newNames;
            this.currentExpressions = newExpressions;
        }
        if (newNames == null) {
            return null;
        }
        ArrayList<VType> values = new ArrayList<VType>();
        for (DesiredRateExpression<?> desiredRateExpression : this.currentExpressions) {
            if (desiredRateExpression == null) continue;
            Object value = desiredRateExpression.getFunction().readValue();
            if (value != null && !(value instanceof VType)) {
                throw new IllegalArgumentException("Only VTypes allowed in value tables");
            }
            values.add((VType)value);
        }
        return VTableFactory.valueTable(this.previousNames, values);
    }

    @Override
    public Object calculate(List<Object> args) {
        VStringArray value = (VStringArray)args.get(0);
        List newNames = null;
        if (value != null) {
            newNames = value.getData();
        }
        return this.calculateImpl(newNames);
    }

    @Override
    public void dispose() {
        for (DesiredRateExpression<?> desiredRateExpression : new HashSet(this.currentExpressions)) {
            this.getDirector().disconnectReadExpression(desiredRateExpression);
        }
        this.currentExpressions = null;
        this.previousNames = null;
    }
}

