/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.formula;

import java.util.Arrays;
import java.util.List;
import org.epics.pvmanager.formula.FormulaFunction;
import org.epics.vtype.VString;
import org.epics.vtype.VTable;
import org.epics.vtype.table.VTableFactory;

class TableStringMatchFilterFunction
implements FormulaFunction {
    TableStringMatchFilterFunction() {
    }

    @Override
    public boolean isPure() {
        return true;
    }

    @Override
    public boolean isVarArgs() {
        return false;
    }

    @Override
    public String getName() {
        return "tableStringMatchFilter";
    }

    @Override
    public String getDescription() {
        return "Extract the rows where the column value contains the given string";
    }

    @Override
    public List<Class<?>> getArgumentTypes() {
        return Arrays.asList(VTable.class, VString.class, VString.class);
    }

    @Override
    public List<String> getArgumentNames() {
        return Arrays.asList("table", "columName", "substring");
    }

    @Override
    public Class<?> getReturnType() {
        return VTable.class;
    }

    @Override
    public Object calculate(List<Object> args) {
        VTable table = (VTable)args.get(0);
        VString columnName = (VString)args.get(1);
        VString substring = (VString)args.get(2);
        if (columnName == null || columnName.getValue() == null || table == null || substring == null) {
            return null;
        }
        VTable result = VTableFactory.tableStringMatchFilter((VTable)table, (String)columnName.getValue(), (String)substring.getValue());
        return result;
    }
}

