/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.file;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import org.epics.pvmanager.ChannelWriteCallback;
import org.epics.pvmanager.MultiplexedChannelHandler;
import org.epics.vtype.VTable;
import org.epics.vtype.io.CSVIO;

class FileChannelHandler
extends MultiplexedChannelHandler<File, Object> {
    private File file;
    private CSVIO io = new CSVIO();

    FileChannelHandler(String channelName, File file) {
        super(channelName);
        this.file = file;
    }

    public void connect() {
        this.processConnection(this.file);
        try {
            Object value = this.readValueFromFile(this.file);
            this.processMessage(value);
        }
        catch (Exception ex) {
            this.reportExceptionToAllReadersAndWriters(ex);
        }
    }

    protected Object readValueFromFile(File file) throws Exception {
        FileReader fileReader = new FileReader(file);
        VTable value = this.io.importVTable((Reader)fileReader);
        return value;
    }

    public void disconnect() {
        this.processConnection(null);
    }

    protected boolean isConnected(File payload) {
        return payload != null && payload.exists() && payload.isFile();
    }

    protected void write(Object newValue, ChannelWriteCallback callback) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

