/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.file;

import java.io.File;
import java.net.URI;
import org.epics.pvmanager.ChannelHandler;
import org.epics.pvmanager.DataSource;
import org.epics.pvmanager.file.CSVFileFormat;
import org.epics.pvmanager.file.FileChannelHandler;
import org.epics.pvmanager.file.FileFormatRegistry;
import org.epics.pvmanager.file.FileWatcherFileSystemService;
import org.epics.pvmanager.file.FileWatcherService;
import org.epics.pvmanager.util.Executors;
import org.epics.pvmanager.vtype.DataTypeSupport;
import org.epics.util.time.TimeDuration;

public final class FileDataSource
extends DataSource {
    private static final FileFormatRegistry register = FileFormatRegistry.getDefault();
    private final FileWatcherService fileWatchService = new FileWatcherFileSystemService(java.util.concurrent.Executors.newSingleThreadScheduledExecutor(Executors.namedPool((String)"diirt - file watch")), TimeDuration.ofSeconds((double)1.0));

    public FileDataSource() {
        super(true);
    }

    FileWatcherService getFileWatchService() {
        return this.fileWatchService;
    }

    protected ChannelHandler createChannel(String channelName) {
        String fileExt;
        if (channelName.contains(".") && register.contains(fileExt = channelName.substring(channelName.lastIndexOf(46) + 1, channelName.length()))) {
            return new FileChannelHandler(this, channelName, new File(URI.create("file://" + channelName)), register.getFileFormatFor(fileExt));
        }
        return new FileChannelHandler(this, channelName, new File(URI.create("file://" + channelName)), new CSVFileFormat());
    }

    static {
        DataTypeSupport.install();
    }
}

