/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.file;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.epics.pvmanager.file.FileFormat;

public class FileFormatRegistry {
    private static final FileFormatRegistry registry = new FileFormatRegistry();
    private static final Map<String, FileFormat> fileFormatRegistry = new ConcurrentHashMap<String, FileFormat>();

    public static FileFormatRegistry getDefault() {
        return registry;
    }

    public void registerFileFormat(String extension, FileFormat format) {
        fileFormatRegistry.put(extension, format);
    }

    public FileFormat getFileFormatFor(String extension) {
        return fileFormatRegistry.get(extension);
    }

    public boolean contains(String extension) {
        return fileFormatRegistry.containsKey(extension);
    }
}

