/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.graphene;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.epics.graphene.AreaGraph2DRenderer;
import org.epics.graphene.AreaGraph2DRendererUpdate;
import org.epics.graphene.Cell1DDataset;
import org.epics.graphene.Graph2DRendererUpdate;
import org.epics.graphene.Histogram1D;
import org.epics.graphene.Histogram1DUpdate;
import org.epics.graphene.Histograms;
import org.epics.graphene.Point1DCircularBuffer;
import org.epics.graphene.Point1DDataset;
import org.epics.graphene.Point1DDatasetUpdate;
import org.epics.graphene.Range;
import org.epics.pvmanager.QueueCollector;
import org.epics.pvmanager.ReadFunction;
import org.epics.pvmanager.graphene.Graph2DResult;
import org.epics.pvmanager.graphene.GraphDataRange;
import org.epics.vtype.VNumber;
import org.epics.vtype.ValueUtil;

class AreaGraph2DFunction
implements ReadFunction<Graph2DResult> {
    private ReadFunction<? extends List<? extends VNumber>> argument;
    private Point1DCircularBuffer dataset = new Point1DCircularBuffer(1000000);
    private Histogram1D histogram = Histograms.createHistogram((Point1DDataset)this.dataset);
    private AreaGraph2DRenderer renderer = new AreaGraph2DRenderer(300, 200);
    private Graph2DResult previousImage;
    private List<Histogram1DUpdate> histogramUpdates = Collections.synchronizedList(new ArrayList());
    private QueueCollector<AreaGraph2DRendererUpdate> rendererUpdateQueue = new QueueCollector(100);

    public AreaGraph2DFunction(ReadFunction<? extends List<? extends VNumber>> argument) {
        this.argument = argument;
    }

    public void update(Histogram1DUpdate update) {
        this.histogramUpdates.add(update);
    }

    public QueueCollector<AreaGraph2DRendererUpdate> getUpdateQueue() {
        return this.rendererUpdateQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Graph2DResult readValue() {
        List newData = (List)this.argument.readValue();
        List rendererUpdates = this.rendererUpdateQueue.readValue();
        if (newData.isEmpty() && this.previousImage != null && this.histogramUpdates.isEmpty() && rendererUpdates.isEmpty()) {
            return this.previousImage;
        }
        Point1DDatasetUpdate update = new Point1DDatasetUpdate();
        for (VNumber vNumber : newData) {
            update.addData(vNumber.getValue().doubleValue());
        }
        this.dataset.update(update);
        Iterator i$ = this.histogramUpdates;
        synchronized (i$) {
            for (Histogram1DUpdate histogramUpdate : this.histogramUpdates) {
                this.histogram.update(histogramUpdate);
            }
            this.histogramUpdates.clear();
        }
        this.histogram.update(new Histogram1DUpdate().recalculateFrom((Point1DDataset)this.dataset));
        for (AreaGraph2DRendererUpdate rendererUpdate : rendererUpdates) {
            this.renderer.update((Graph2DRendererUpdate)rendererUpdate);
        }
        if (this.renderer.getImageHeight() == 0 && this.renderer.getImageWidth() == 0) {
            return null;
        }
        BufferedImage image = new BufferedImage(this.renderer.getImageWidth(), this.renderer.getImageHeight(), 5);
        this.renderer.draw(image.createGraphics(), (Cell1DDataset)this.histogram);
        return new Graph2DResult(ValueUtil.toVImage((BufferedImage)image), new GraphDataRange(this.renderer.getXPlotRange(), this.histogram.getXRange(), this.renderer.getXAggregatedRange()), new GraphDataRange(this.renderer.getYPlotRange(), (Range)this.histogram.getStatistics(), this.renderer.getYAggregatedRange()));
    }
}

