/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.graphene;

import java.awt.image.BufferedImage;
import java.util.List;
import org.epics.graphene.LineGraph2DRenderer;
import org.epics.graphene.LineGraph2DRendererUpdate;
import org.epics.graphene.Point2DDataset;
import org.epics.graphene.Point2DDatasets;
import org.epics.graphene.Range;
import org.epics.pvmanager.QueueCollector;
import org.epics.pvmanager.ReadFunction;
import org.epics.pvmanager.graphene.Graph2DResult;
import org.epics.pvmanager.graphene.GraphDataRange;
import org.epics.util.array.ListNumber;
import org.epics.vtype.VImage;
import org.epics.vtype.VNumber;
import org.epics.vtype.VNumberArray;
import org.epics.vtype.ValueUtil;

class LineGraph2DFunction
implements ReadFunction<Graph2DResult> {
    private ReadFunction<? extends VNumberArray> yArray;
    private ReadFunction<? extends VNumberArray> xArray;
    private ReadFunction<? extends VNumber> xInitialOffset;
    private ReadFunction<? extends VNumber> xIncrementSize;
    private LineGraph2DRenderer renderer = new LineGraph2DRenderer(300, 200);
    private VImage previousImage;
    private final QueueCollector<LineGraph2DRendererUpdate> rendererUpdateQueue = new QueueCollector(100);

    public LineGraph2DFunction(ReadFunction<? extends VNumberArray> argument) {
        this.yArray = argument;
    }

    public LineGraph2DFunction(ReadFunction<? extends VNumberArray> xArray, ReadFunction<? extends VNumberArray> yArray) {
        this.xArray = xArray;
        this.yArray = yArray;
    }

    public LineGraph2DFunction(ReadFunction<? extends VNumberArray> yArray, ReadFunction<? extends VNumber> xInitialOffset, ReadFunction<? extends VNumber> xIncrementSize) {
        this.xInitialOffset = xInitialOffset;
        this.xIncrementSize = xIncrementSize;
        this.yArray = yArray;
    }

    public QueueCollector<LineGraph2DRendererUpdate> getRendererUpdateQueue() {
        return this.rendererUpdateQueue;
    }

    public Graph2DResult readValue() {
        VNumberArray newData = (VNumberArray)this.yArray.readValue();
        if (newData == null || newData.getData() == null) {
            return null;
        }
        Point2DDataset dataset = null;
        if (this.xArray != null) {
            VNumberArray xData = (VNumberArray)this.xArray.readValue();
            if (xData != null && newData.getData() != null) {
                dataset = Point2DDatasets.lineData((ListNumber)xData.getData(), (ListNumber)newData.getData());
            }
        } else if (this.xInitialOffset != null && this.xIncrementSize != null) {
            VNumber initialOffet = (VNumber)this.xInitialOffset.readValue();
            VNumber incrementSize = (VNumber)this.xIncrementSize.readValue();
            if (initialOffet != null && initialOffet.getValue() != null && incrementSize != null && incrementSize.getValue() != null) {
                dataset = Point2DDatasets.lineData((ListNumber)newData.getData(), (double)initialOffet.getValue().doubleValue(), (double)incrementSize.getValue().doubleValue());
            }
        }
        if (dataset == null) {
            dataset = Point2DDatasets.lineData((ListNumber)newData.getData());
        }
        List updates = this.rendererUpdateQueue.readValue();
        for (LineGraph2DRendererUpdate rendererUpdate : updates) {
            this.renderer.update(rendererUpdate);
        }
        if (this.renderer.getImageHeight() == 0 && this.renderer.getImageWidth() == 0) {
            return null;
        }
        BufferedImage image = new BufferedImage(this.renderer.getImageWidth(), this.renderer.getImageHeight(), 5);
        this.renderer.draw(image.createGraphics(), dataset);
        this.previousImage = ValueUtil.toVImage((BufferedImage)image);
        return new Graph2DResult(this.previousImage, new GraphDataRange(this.renderer.getXPlotRange(), (Range)dataset.getXStatistics(), this.renderer.getXAggregatedRange()), new GraphDataRange(this.renderer.getYPlotRange(), (Range)dataset.getYStatistics(), this.renderer.getYAggregatedRange()));
    }
}

