/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.graphene;

import java.awt.image.BufferedImage;
import java.util.List;
import org.epics.graphene.Point2DDataset;
import org.epics.graphene.Point2DDatasets;
import org.epics.graphene.ScatterGraph2DRenderer;
import org.epics.graphene.ScatterGraph2DRendererUpdate;
import org.epics.pvmanager.QueueCollector;
import org.epics.pvmanager.ReadFunction;
import org.epics.pvmanager.graphene.Graph2DResult;
import org.epics.pvmanager.graphene.GraphDataRange;
import org.epics.util.array.ListNumber;
import org.epics.vtype.VImage;
import org.epics.vtype.VNumberArray;
import org.epics.vtype.ValueUtil;

public class ScatterGraph2DFunction
implements ReadFunction<Graph2DResult> {
    private ReadFunction<? extends VNumberArray> yArray;
    private ReadFunction<? extends VNumberArray> xArray;
    private ScatterGraph2DRenderer renderer = new ScatterGraph2DRenderer(300, 200);
    private VImage previousImage;
    private final QueueCollector<ScatterGraph2DRendererUpdate> rendererUpdateQueue = new QueueCollector(100);

    public ScatterGraph2DFunction(ReadFunction<? extends VNumberArray> yArray, ReadFunction<? extends VNumberArray> xArray) {
        this.yArray = yArray;
        this.xArray = xArray;
    }

    public QueueCollector<ScatterGraph2DRendererUpdate> getRendererUpdateQueue() {
        return this.rendererUpdateQueue;
    }

    public Graph2DResult readValue() {
        VNumberArray newYData = (VNumberArray)this.yArray.readValue();
        VNumberArray newXData = (VNumberArray)this.xArray.readValue();
        if (newYData == null || newYData.getData() == null) {
            return null;
        }
        if (newXData == null || newXData.getData() == null) {
            return null;
        }
        Point2DDataset dataset = null;
        dataset = Point2DDatasets.lineData((ListNumber)newXData.getData(), (ListNumber)newYData.getData());
        List updates = this.rendererUpdateQueue.readValue();
        for (ScatterGraph2DRendererUpdate scatterGraph2DRendererUpdate : updates) {
            this.renderer.update(scatterGraph2DRendererUpdate);
        }
        if (this.renderer.getImageHeight() == 0 && this.renderer.getImageWidth() == 0) {
            return null;
        }
        BufferedImage image = new BufferedImage(this.renderer.getImageWidth(), this.renderer.getImageHeight(), 5);
        this.renderer.draw(image.createGraphics(), dataset);
        this.previousImage = ValueUtil.toVImage((BufferedImage)image);
        return new Graph2DResult(this.previousImage, new GraphDataRange(this.renderer.getXPlotRange(), this.renderer.getXPlotRange(), this.renderer.getXAggregatedRange()), new GraphDataRange(this.renderer.getYPlotRange(), this.renderer.getYPlotRange(), this.renderer.getYAggregatedRange()));
    }
}

