/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.graphene;

import java.awt.image.BufferedImage;
import java.util.List;
import org.epics.graphene.BubbleGraph2DRenderer;
import org.epics.graphene.BubbleGraph2DRendererUpdate;
import org.epics.graphene.Graph2DRendererUpdate;
import org.epics.graphene.Point3DWithLabelDataset;
import org.epics.pvmanager.QueueCollector;
import org.epics.pvmanager.ReadFunction;
import org.epics.pvmanager.graphene.ArgumentExpressions;
import org.epics.pvmanager.graphene.CheckedReadFunction;
import org.epics.pvmanager.graphene.DatasetConversions;
import org.epics.pvmanager.graphene.Graph2DResult;
import org.epics.pvmanager.graphene.GraphDataRange;
import org.epics.pvmanager.graphene.ReadFunctionArgument;
import org.epics.vtype.VImage;
import org.epics.vtype.VTable;
import org.epics.vtype.VType;
import org.epics.vtype.ValueUtil;

public class BubbleGraph2DFunction
implements ReadFunction<Graph2DResult> {
    private ReadFunction<? extends VTable> tableData;
    private ReadFunctionArgument<String> xColumnName;
    private ReadFunctionArgument<String> yColumnName;
    private ReadFunctionArgument<String> sizeColumnName;
    private ReadFunctionArgument<String> tooltipColumnName;
    private BubbleGraph2DRenderer renderer = new BubbleGraph2DRenderer(300, 200);
    private VImage previousImage;
    private final QueueCollector<BubbleGraph2DRendererUpdate> rendererUpdateQueue = new QueueCollector(100);

    public BubbleGraph2DFunction(ReadFunction<?> tableData, ReadFunction<?> xColumnName, ReadFunction<?> yColumnName, ReadFunction<?> sizeColumnName, ReadFunction<?> tooltipColumnName) {
        this.tableData = new CheckedReadFunction<VTable>(tableData, "Data", VTable.class);
        this.xColumnName = ArgumentExpressions.stringArgument(xColumnName, "X Column");
        this.yColumnName = ArgumentExpressions.stringArgument(yColumnName, "Y Column");
        this.sizeColumnName = ArgumentExpressions.stringArgument(sizeColumnName, "Size Column");
        this.tooltipColumnName = ArgumentExpressions.stringArgument(tooltipColumnName, "Tooltip Column");
    }

    public QueueCollector<BubbleGraph2DRendererUpdate> getRendererUpdateQueue() {
        return this.rendererUpdateQueue;
    }

    public Graph2DResult readValue() {
        VTable vTable = (VTable)this.tableData.readValue();
        this.xColumnName.readNext();
        this.yColumnName.readNext();
        this.sizeColumnName.readNext();
        this.tooltipColumnName.readNext();
        if (vTable == null || this.xColumnName.isMissing() || this.yColumnName.isMissing() || this.sizeColumnName.isMissing()) {
            return null;
        }
        Point3DWithLabelDataset dataset = DatasetConversions.point3DDatasetFromVTable(vTable, this.xColumnName.getValue(), this.yColumnName.getValue(), this.sizeColumnName.getValue());
        List updates = this.rendererUpdateQueue.readValue();
        for (BubbleGraph2DRendererUpdate scatterGraph2DRendererUpdate : updates) {
            this.renderer.update((Graph2DRendererUpdate)scatterGraph2DRendererUpdate);
        }
        if (this.renderer.getImageHeight() == 0 && this.renderer.getImageWidth() == 0) {
            return null;
        }
        BufferedImage image = new BufferedImage(this.renderer.getImageWidth(), this.renderer.getImageHeight(), 5);
        this.renderer.draw(image.createGraphics(), dataset);
        this.previousImage = ValueUtil.toVImage((BufferedImage)image);
        return new Graph2DResult((VType)vTable, this.previousImage, new GraphDataRange(this.renderer.getXPlotRange(), this.renderer.getXPlotRange(), this.renderer.getXAggregatedRange()), new GraphDataRange(this.renderer.getYPlotRange(), this.renderer.getYPlotRange(), this.renderer.getYAggregatedRange()), -1);
    }
}

