/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.graphene;

import java.util.Collections;
import org.epics.graphene.Point2DDataset;
import org.epics.graphene.Point2DDatasets;
import org.epics.graphene.Point3DWithLabelDataset;
import org.epics.graphene.Point3DWithLabelDatasets;
import org.epics.util.array.ListNumber;
import org.epics.vtype.VTable;
import org.epics.vtype.ValueUtil;

public class DatasetConversions {
    public static Point2DDataset point2DDatasetFromVTable(VTable vTable, String xColumn, String yColumn) {
        ListNumber xValues = ValueUtil.numericColumnOf((VTable)vTable, (String)xColumn);
        ListNumber yValues = ValueUtil.numericColumnOf((VTable)vTable, (String)yColumn);
        for (int i = 0; i < vTable.getColumnCount(); ++i) {
            if (!vTable.getColumnType(i).isPrimitive() || vTable.getColumnName(i).equals(xColumn) || vTable.getColumnName(i).equals(yColumn)) continue;
            if (xValues == null) {
                xValues = (ListNumber)vTable.getColumnData(i);
                continue;
            }
            if (yValues != null) continue;
            yValues = (ListNumber)vTable.getColumnData(i);
        }
        if (xValues == null || yValues == null) {
            throw new IllegalArgumentException("Couldn't find two numeric columns");
        }
        return Point2DDatasets.lineData((ListNumber)xValues, (ListNumber)yValues);
    }

    public static Point3DWithLabelDataset point3DDatasetFromVTable(VTable vTable, String xColumn, String yColumn, String sizeColumn) {
        ListNumber xValues = ValueUtil.numericColumnOf((VTable)vTable, (String)xColumn);
        ListNumber yValues = ValueUtil.numericColumnOf((VTable)vTable, (String)yColumn);
        ListNumber sizeValues = ValueUtil.numericColumnOf((VTable)vTable, (String)sizeColumn);
        for (int i = 0; i < vTable.getColumnCount(); ++i) {
            if (!vTable.getColumnType(i).isPrimitive() || vTable.getColumnName(i).equals(xColumn) || vTable.getColumnName(i).equals(yColumn)) continue;
            if (xValues == null) {
                xValues = (ListNumber)vTable.getColumnData(i);
                continue;
            }
            if (yValues == null) {
                yValues = (ListNumber)vTable.getColumnData(i);
                continue;
            }
            if (sizeValues != null) continue;
            sizeValues = (ListNumber)vTable.getColumnData(i);
        }
        if (xValues == null || yValues == null) {
            throw new IllegalArgumentException("Couldn't find two numeric columns");
        }
        return Point3DWithLabelDatasets.build((ListNumber)xValues, (ListNumber)yValues, (ListNumber)sizeValues, Collections.nCopies(sizeValues.size(), "None"));
    }
}

