/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.graphene;

import java.util.Arrays;
import java.util.List;
import org.epics.pvmanager.BasicTypeSupport;
import org.epics.pvmanager.NotificationSupport;
import org.epics.pvmanager.ReadFunction;
import org.epics.pvmanager.TypeSupport;
import org.epics.pvmanager.expression.DesiredRateExpression;
import org.epics.pvmanager.expression.DesiredRateExpressionImpl;
import org.epics.pvmanager.expression.DesiredRateExpressionList;
import org.epics.pvmanager.expression.DesiredRateExpressionListImpl;
import org.epics.pvmanager.expression.SourceRateExpression;
import org.epics.pvmanager.graphene.AreaGraph2DExpression;
import org.epics.pvmanager.graphene.AreaGraph2DFunction;
import org.epics.pvmanager.graphene.BubbleGraph2DExpression;
import org.epics.pvmanager.graphene.Graph2DResult;
import org.epics.pvmanager.graphene.LineGraph2DExpression;
import org.epics.pvmanager.graphene.ListDoubleView;
import org.epics.pvmanager.graphene.ScatterGraph2DExpression;
import org.epics.pvmanager.vtype.DataTypeSupport;
import org.epics.util.array.ListNumbers;
import org.epics.vtype.VNumber;
import org.epics.vtype.VNumberArray;
import org.epics.vtype.VTable;
import org.epics.vtype.ValueFactory;

public class ExpressionLanguage {
    private ExpressionLanguage() {
    }

    public static AreaGraph2DExpression histogramOf(SourceRateExpression<? extends VNumber> vDoubles) {
        DesiredRateExpression queue = org.epics.pvmanager.ExpressionLanguage.newValuesOf(vDoubles);
        return new AreaGraph2DExpression((DesiredRateExpressionList<?>)queue, new AreaGraph2DFunction((ReadFunction<? extends List<? extends VNumber>>)queue.getFunction()), "histogram");
    }

    public static AreaGraph2DExpression histogramOf(DesiredRateExpression<? extends List<? extends VNumber>> vDoubles) {
        return new AreaGraph2DExpression((DesiredRateExpressionList<?>)vDoubles, new AreaGraph2DFunction((ReadFunction<? extends List<? extends VNumber>>)vDoubles.getFunction()), "histogram");
    }

    public static LineGraph2DExpression lineGraphOf(DesiredRateExpression<? extends VNumberArray> vDoubleArray) {
        return ExpressionLanguage.lineGraphOf(vDoubleArray, null, null, null);
    }

    public static LineGraph2DExpression lineGraphOf(final DesiredRateExpression<? extends VNumberArray> yArray, final DesiredRateExpression<? extends VNumber> xInitialOffset, final DesiredRateExpression<? extends VNumber> xIncrementSize) {
        DesiredRateExpressionImpl data = new DesiredRateExpressionImpl(ExpressionLanguage.createList(new DesiredRateExpressionList[]{yArray, xInitialOffset, xIncrementSize}), (ReadFunction)new ReadFunction<VTable>(){

            public VTable readValue() {
                VNumberArray values = (VNumberArray)yArray.getFunction().readValue();
                VNumber offset = (VNumber)xInitialOffset.getFunction().readValue();
                VNumber increment = (VNumber)xIncrementSize.getFunction().readValue();
                if (values == null || offset == null || increment == null) {
                    return null;
                }
                return ValueFactory.newVTable(Arrays.asList(Double.TYPE, Double.TYPE), Arrays.asList("X", "Y"), Arrays.asList(new Object[]{ListNumbers.linearList((double)offset.getValue().doubleValue(), (double)increment.getValue().doubleValue(), (int)values.getData().size()), new ListDoubleView(values.getData())}));
            }
        }, "data");
        return ExpressionLanguage.lineGraphOf(data, null, null, null);
    }

    public static LineGraph2DExpression lineGraphOf(final DesiredRateExpression<? extends VNumberArray> xVDoubleArray, final DesiredRateExpression<? extends VNumberArray> yVDoubleArray) {
        DesiredRateExpressionImpl data = new DesiredRateExpressionImpl(ExpressionLanguage.createList(new DesiredRateExpressionList[]{xVDoubleArray, yVDoubleArray}), (ReadFunction)new ReadFunction<VTable>(){

            public VTable readValue() {
                VNumberArray xValues = (VNumberArray)xVDoubleArray.getFunction().readValue();
                VNumberArray yValues = (VNumberArray)yVDoubleArray.getFunction().readValue();
                if (xValues == null || yValues == null) {
                    return null;
                }
                return ValueFactory.newVTable(Arrays.asList(Double.TYPE, Double.TYPE), Arrays.asList("X", "Y"), Arrays.asList(new Object[]{new ListDoubleView(xValues.getData()), new ListDoubleView(yValues.getData())}));
            }
        }, "data");
        return ExpressionLanguage.lineGraphOf(data, null, null, null);
    }

    public static LineGraph2DExpression lineGraphOf(DesiredRateExpression<?> tableData, DesiredRateExpression<?> xColumnName, DesiredRateExpression<?> yColumnName, DesiredRateExpression<?> tooltipColumnName) {
        return new LineGraph2DExpression(tableData, xColumnName, yColumnName, tooltipColumnName);
    }

    public static ScatterGraph2DExpression scatterGraphOf(DesiredRateExpression<?> tableData, DesiredRateExpression<?> xColumnName, DesiredRateExpression<?> yColumnName, DesiredRateExpression<?> tooltipColumnName) {
        return new ScatterGraph2DExpression(tableData, xColumnName, yColumnName, tooltipColumnName);
    }

    public static BubbleGraph2DExpression bubbleGraphOf(DesiredRateExpression<?> tableData, DesiredRateExpression<?> xColumnName, DesiredRateExpression<?> yColumnName, DesiredRateExpression<?> sizeColumnName, DesiredRateExpression<?> tooltipColumnName) {
        return new BubbleGraph2DExpression(tableData, xColumnName, yColumnName, sizeColumnName, tooltipColumnName);
    }

    @SafeVarargs
    static <T> DesiredRateExpressionList<T> createList(DesiredRateExpressionList<? extends T> ... expressions) {
        DesiredRateExpressionListImpl list = new DesiredRateExpressionListImpl();
        for (DesiredRateExpressionList<? extends T> exp : expressions) {
            if (exp == null) continue;
            list.and(exp);
        }
        return list;
    }

    static <T> ReadFunction<T> functionOf(DesiredRateExpression<T> exp) {
        if (exp == null) {
            return null;
        }
        return exp.getFunction();
    }

    static {
        DataTypeSupport.install();
        BasicTypeSupport.install();
        TypeSupport.addTypeSupport((TypeSupport)NotificationSupport.immutableTypeSupport(Graph2DResult.class));
    }
}

