/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.graphene;

import java.util.Objects;
import org.epics.pvmanager.ReadFunction;

public class ReadFunctionArgument<T> {
    private T value;
    private final ReadFunction<T> function;
    private boolean changed;

    public ReadFunctionArgument(ReadFunction<T> function) {
        this.function = function;
    }

    public ReadFunctionArgument() {
        this(null);
    }

    public boolean isDefined() {
        return this.function != null;
    }

    public boolean isMissing() {
        return this.isDefined() && this.getValue() == null;
    }

    public void readNext() {
        if (this.function != null) {
            T oldValue = this.value;
            this.value = this.function.readValue();
            this.changed = !Objects.equals(oldValue, this.value);
        } else {
            this.changed = false;
        }
    }

    public boolean isChanged() {
        return this.changed;
    }

    public T getValue() {
        return this.value;
    }
}

