/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.graphene;

import java.util.Collections;
import java.util.List;
import org.epics.graphene.Point2DDataset;
import org.epics.graphene.Point2DDatasets;
import org.epics.graphene.Point3DWithLabelDataset;
import org.epics.graphene.Point3DWithLabelDatasets;
import org.epics.util.array.ListDouble;
import org.epics.util.array.ListNumber;
import org.epics.vtype.VTable;
import org.epics.vtype.ValueUtil;

public class DatasetConversions {
    public static Point2DDataset point2DDatasetFromVTable(VTable vTable, String xColumn, String yColumn) {
        ListNumber xValues = ValueUtil.numericColumnOf((VTable)vTable, (String)xColumn);
        ListNumber yValues = ValueUtil.numericColumnOf((VTable)vTable, (String)yColumn);
        for (int i = 0; i < vTable.getColumnCount(); ++i) {
            if (!vTable.getColumnType(i).isPrimitive() || vTable.getColumnName(i).equals(xColumn) || vTable.getColumnName(i).equals(yColumn)) continue;
            if (xValues == null) {
                xValues = (ListNumber)vTable.getColumnData(i);
                continue;
            }
            if (yValues != null) continue;
            yValues = (ListNumber)vTable.getColumnData(i);
        }
        if (xValues == null || yValues == null) {
            throw new IllegalArgumentException("Couldn't find two numeric columns");
        }
        return Point2DDatasets.lineData((ListNumber)xValues, (ListNumber)yValues);
    }

    public static Point3DWithLabelDataset point3DDatasetFromVTable(VTable vTable, String xColumn, String yColumn, String sizeColumn, String colorColumn) {
        ListNumber xValues = ValueUtil.numericColumnOf((VTable)vTable, (String)xColumn);
        ListNumber yValues = ValueUtil.numericColumnOf((VTable)vTable, (String)yColumn);
        Object sizeValues = ValueUtil.numericColumnOf((VTable)vTable, (String)sizeColumn);
        List colorValues = ValueUtil.stringColumnOf((VTable)vTable, (String)colorColumn);
        if (xValues == null && yValues == null && sizeValues == null && colorValues == null) {
            for (int i = 0; i < vTable.getColumnCount(); ++i) {
                List list;
                if (vTable.getColumnType(i).isPrimitive()) {
                    if (xValues == null) {
                        xValues = (ListNumber)vTable.getColumnData(i);
                        continue;
                    }
                    if (yValues == null) {
                        yValues = (ListNumber)vTable.getColumnData(i);
                        continue;
                    }
                    if (sizeValues != null) continue;
                    sizeValues = (ListNumber)vTable.getColumnData(i);
                    continue;
                }
                if (!vTable.getColumnType(i).equals(String.class) || colorValues != null) continue;
                colorValues = list = (List)vTable.getColumnData(i);
            }
            if (xValues == null || yValues == null) {
                throw new IllegalArgumentException("Couldn't find two numeric columns for X and Y");
            }
        }
        if (xValues == null || yValues == null) {
            throw new IllegalArgumentException("X and Y must both be specified");
        }
        final int nValues = xValues.size();
        if (sizeValues == null) {
            sizeValues = new ListDouble(){

                public double getDouble(int index) {
                    return 0.0;
                }

                public int size() {
                    return nValues;
                }
            };
        }
        if (colorValues == null) {
            colorValues = Collections.nCopies(xValues.size(), "None");
        }
        return Point3DWithLabelDatasets.build((ListNumber)xValues, (ListNumber)yValues, (ListNumber)sizeValues, colorValues);
    }
}

