/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.graphene;

import java.awt.image.BufferedImage;
import org.epics.graphene.Cell2DDataset;
import org.epics.graphene.Cell2DDatasets;
import org.epics.graphene.IntensityGraph2DRenderer;
import org.epics.graphene.IntensityGraph2DRendererUpdate;
import org.epics.pvmanager.QueueCollector;
import org.epics.pvmanager.ReadFunction;
import org.epics.pvmanager.graphene.CheckedReadFunction;
import org.epics.pvmanager.graphene.Graph2DResult;
import org.epics.util.array.ArrayDouble;
import org.epics.util.array.ListNumber;
import org.epics.vtype.ArrayDimensionDisplay;
import org.epics.vtype.VNumberArray;
import org.epics.vtype.ValueUtil;

class IntensityGraph2DFunction
implements ReadFunction<Graph2DResult> {
    private ReadFunction<VNumberArray> arrayData;
    private IntensityGraph2DRenderer renderer = new IntensityGraph2DRenderer(300, 200);
    private Graph2DResult previousImage;
    private final QueueCollector<IntensityGraph2DRendererUpdate> rendererUpdateQueue = new QueueCollector(100);

    public IntensityGraph2DFunction(ReadFunction<?> arrayData) {
        this.arrayData = new CheckedReadFunction<VNumberArray>(arrayData, "Data", VNumberArray.class);
    }

    public QueueCollector<IntensityGraph2DRendererUpdate> getUpdateQueue() {
        return this.rendererUpdateQueue;
    }

    public Graph2DResult readValue() {
        VNumberArray data = (VNumberArray)this.arrayData.readValue();
        if (data == null) {
            return null;
        }
        Cell2DDataset dataset = null;
        try {
            dataset = data.getSizes().size() == 1 ? Cell2DDatasets.datasetFrom((ListNumber)data.getData(), (ListNumber)new ArrayDouble(new double[]{0.0, 1.0}), (ListNumber)((ArrayDimensionDisplay)data.getDimensionDisplay().get(0)).getCellBoundaries()) : Cell2DDatasets.datasetFrom((ListNumber)data.getData(), (ListNumber)((ArrayDimensionDisplay)data.getDimensionDisplay().get(1)).getCellBoundaries(), (ListNumber)((ArrayDimensionDisplay)data.getDimensionDisplay().get(0)).getCellBoundaries());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        for (IntensityGraph2DRendererUpdate rendererUpdate : this.getUpdateQueue().readValue()) {
            this.renderer.update(rendererUpdate);
        }
        if (this.renderer.getImageHeight() == 0 && this.renderer.getImageWidth() == 0) {
            return null;
        }
        BufferedImage image = new BufferedImage(this.renderer.getImageWidth(), this.renderer.getImageHeight(), 5);
        this.renderer.draw(image.createGraphics(), dataset);
        return new Graph2DResult(null, ValueUtil.toVImage((BufferedImage)image), null, null, -1);
    }
}

