/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.graphene;

import org.epics.graphene.Cell2DDataset;
import org.epics.graphene.Range;
import org.epics.graphene.RangeUtil;
import org.epics.graphene.Statistics;
import org.epics.graphene.StatisticsUtil;
import org.epics.util.array.ArrayDouble;
import org.epics.util.array.CollectionNumber;
import org.epics.util.array.ListNumber;
import org.epics.vtype.ArrayDimensionDisplay;
import org.epics.vtype.VNumberArray;

class Cell2DDatasetFromVNumberArray
implements Cell2DDataset {
    private Statistics statistics;
    private final ListNumber xBoundaries;
    private final ListNumber yBoundaries;
    private final Range xRange;
    private final Range yRange;
    private final Range displayRange;
    private final int xCount;
    private final int yCount;
    private final VNumberArray data;
    private final ListNumber values;

    public Cell2DDatasetFromVNumberArray(VNumberArray data) {
        this.data = data;
        this.values = data.getData();
        if (data.getSizes().size() == 1) {
            this.xBoundaries = ((ArrayDimensionDisplay)data.getDimensionDisplay().get(0)).getCellBoundaries();
            this.yBoundaries = new ArrayDouble(new double[]{0.0, 1.0});
        } else if (data.getSizes().size() == 2) {
            this.xBoundaries = ((ArrayDimensionDisplay)data.getDimensionDisplay().get(1)).getCellBoundaries();
            this.yBoundaries = ((ArrayDimensionDisplay)data.getDimensionDisplay().get(0)).getCellBoundaries();
        } else {
            throw new IllegalArgumentException("Array is 3D or more");
        }
        this.xRange = RangeUtil.range((double)this.xBoundaries.getDouble(0), (double)this.xBoundaries.getDouble(this.xBoundaries.size() - 1));
        this.yRange = RangeUtil.range((double)this.yBoundaries.getDouble(0), (double)this.yBoundaries.getDouble(this.yBoundaries.size() - 1));
        this.xCount = this.xBoundaries.size() - 1;
        this.yCount = this.yBoundaries.size() - 1;
        this.displayRange = RangeUtil.range((double)data.getLowerDisplayLimit(), (double)data.getUpperDisplayLimit());
    }

    public double getValue(int x, int y) {
        return this.values.getDouble(y * this.xCount + x);
    }

    public Statistics getStatistics() {
        if (this.statistics == null) {
            this.statistics = StatisticsUtil.lazyStatisticsOf((CollectionNumber)this.values);
        }
        return this.statistics;
    }

    public Range getDisplayRange() {
        return this.displayRange;
    }

    public ListNumber getXBoundaries() {
        return this.xBoundaries;
    }

    public Range getXRange() {
        return this.xRange;
    }

    public int getXCount() {
        return this.xCount;
    }

    public ListNumber getYBoundaries() {
        return this.yBoundaries;
    }

    public Range getYRange() {
        return this.yRange;
    }

    public int getYCount() {
        return this.yCount;
    }
}

