/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.graphene;

import java.awt.image.BufferedImage;
import org.epics.graphene.AreaGraph2DRenderer;
import org.epics.graphene.AreaGraph2DRendererUpdate;
import org.epics.graphene.Cell1DDataset;
import org.epics.graphene.Cell1DDatasets;
import org.epics.graphene.Range;
import org.epics.pvmanager.QueueCollector;
import org.epics.pvmanager.ReadFunction;
import org.epics.pvmanager.graphene.CheckedReadFunction;
import org.epics.pvmanager.graphene.Graph2DResult;
import org.epics.pvmanager.graphene.GraphDataRange;
import org.epics.util.array.ListNumber;
import org.epics.vtype.ArrayDimensionDisplay;
import org.epics.vtype.VNumberArray;
import org.epics.vtype.VType;
import org.epics.vtype.ValueUtil;

class HistogramGraph2DFunction
implements ReadFunction<Graph2DResult> {
    private ReadFunction<VNumberArray> arrayData;
    private AreaGraph2DRenderer renderer = new AreaGraph2DRenderer(300, 200);
    private Graph2DResult previousImage;
    private final QueueCollector<AreaGraph2DRendererUpdate> rendererUpdateQueue = new QueueCollector(100);

    public HistogramGraph2DFunction(ReadFunction<?> arrayData) {
        this.arrayData = new CheckedReadFunction<VNumberArray>(arrayData, "Data", VNumberArray.class);
    }

    public QueueCollector<AreaGraph2DRendererUpdate> getUpdateQueue() {
        return this.rendererUpdateQueue;
    }

    public Graph2DResult readValue() {
        VNumberArray data = (VNumberArray)this.arrayData.readValue();
        if (data == null) {
            return null;
        }
        Cell1DDataset dataset = null;
        try {
            dataset = Cell1DDatasets.datasetFrom((ListNumber)data.getData(), (ListNumber)((ArrayDimensionDisplay)data.getDimensionDisplay().get(0)).getCellBoundaries());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        for (AreaGraph2DRendererUpdate rendererUpdate : this.getUpdateQueue().readValue()) {
            this.renderer.update(rendererUpdate);
        }
        if (this.renderer.getImageHeight() == 0 && this.renderer.getImageWidth() == 0) {
            return null;
        }
        BufferedImage image = new BufferedImage(this.renderer.getImageWidth(), this.renderer.getImageHeight(), 5);
        this.renderer.draw(image.createGraphics(), dataset);
        int index = -1;
        if (this.renderer.getFocusValueIndex() != null) {
            index = this.renderer.getFocusValueIndex();
        }
        return new Graph2DResult((VType)data, ValueUtil.toVImage((BufferedImage)image), new GraphDataRange(this.renderer.getXPlotRange(), dataset.getXRange(), this.renderer.getXAggregatedRange()), new GraphDataRange(this.renderer.getYPlotRange(), (Range)dataset.getStatistics(), this.renderer.getYAggregatedRange()), index);
    }
}

