/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.graphene;

import java.awt.image.BufferedImage;
import java.util.List;
import org.epics.graphene.Cell2DDataset;
import org.epics.graphene.Graph2DRenderer;
import org.epics.graphene.GraphBuffer;
import org.epics.graphene.IntensityGraph2DRenderer;
import org.epics.graphene.IntensityGraph2DRendererUpdate;
import org.epics.graphene.Range;
import org.epics.pvmanager.QueueCollector;
import org.epics.pvmanager.ReadFunction;
import org.epics.pvmanager.graphene.CheckedReadFunction;
import org.epics.pvmanager.graphene.DatasetConversions;
import org.epics.pvmanager.graphene.Graph2DResult;
import org.epics.pvmanager.graphene.GraphDataRange;
import org.epics.vtype.VNumberArray;
import org.epics.vtype.ValueUtil;

class IntensityGraph2DFunction
implements ReadFunction<Graph2DResult> {
    private ReadFunction<VNumberArray> arrayData;
    private IntensityGraph2DRenderer renderer = new IntensityGraph2DRenderer(300, 200);
    private VNumberArray oldData;
    private Graph2DResult previousResult;
    private final QueueCollector<IntensityGraph2DRendererUpdate> rendererUpdateQueue = new QueueCollector(100);

    public IntensityGraph2DFunction(ReadFunction<?> arrayData) {
        this.arrayData = new CheckedReadFunction<VNumberArray>(arrayData, "Data", VNumberArray.class);
    }

    public QueueCollector<IntensityGraph2DRendererUpdate> getUpdateQueue() {
        return this.rendererUpdateQueue;
    }

    public Graph2DResult readValue() {
        VNumberArray data = (VNumberArray)this.arrayData.readValue();
        if (data == null) {
            return null;
        }
        List updates = this.getUpdateQueue().readValue();
        if (data == this.oldData && updates.isEmpty()) {
            return this.previousResult;
        }
        this.oldData = data;
        Cell2DDataset dataset = DatasetConversions.cell2DDatasetsFromVNumberArray(data);
        for (IntensityGraph2DRendererUpdate rendererUpdate : updates) {
            this.renderer.update(rendererUpdate);
        }
        if (this.renderer.getImageHeight() == 0 && this.renderer.getImageWidth() == 0) {
            return null;
        }
        GraphBuffer buffer = new GraphBuffer((Graph2DRenderer)this.renderer);
        this.renderer.draw(buffer, dataset);
        return new Graph2DResult(null, ValueUtil.toVImage((BufferedImage)buffer.getImage()), new GraphDataRange(this.renderer.getXPlotRange(), dataset.getXRange(), this.renderer.getXAggregatedRange()), new GraphDataRange(this.renderer.getYPlotRange(), (Range)dataset.getStatistics(), this.renderer.getYAggregatedRange()), -1);
    }
}

