/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.graphene;

import org.epics.graphene.Cell2DDataset;
import org.epics.util.array.ArrayDouble;
import org.epics.util.array.ArrayInt;
import org.epics.util.array.CollectionNumber;
import org.epics.util.array.ListByte;
import org.epics.util.array.ListInt;
import org.epics.util.array.ListNumber;
import org.epics.util.stats.Range;
import org.epics.util.stats.Ranges;
import org.epics.util.stats.Statistics;
import org.epics.util.stats.StatisticsUtil;
import org.epics.vtype.ArrayDimensionDisplay;
import org.epics.vtype.VNumberArray;
import org.epics.vtype.ndarray.Array2DDouble;

class Cell2DDatasetFromVNumberArray
implements Cell2DDataset {
    private Statistics statistics;
    private final ListNumber xBoundaries;
    private final ListNumber yBoundaries;
    private final Range xRange;
    private final Range yRange;
    private final Range displayRange;
    private final int xCount;
    private final int yCount;
    private final VNumberArray data;
    private final ListNumber values;
    private final Array2DDouble array2D;

    public Cell2DDatasetFromVNumberArray(VNumberArray data) {
        this.data = data;
        this.values = data.getData();
        if (data.getSizes().size() == 1) {
            this.xBoundaries = ((ArrayDimensionDisplay)data.getDimensionDisplay().get(0)).getCellBoundaries();
            this.yBoundaries = new ArrayDouble(new double[]{0.0, 1.0});
            this.array2D = new Array2DDouble((ListInt)new ArrayInt(new int[]{1, this.xBoundaries.size() - 1}), false, ((ArrayDimensionDisplay)data.getDimensionDisplay().get(0)).isReversed());
        } else if (data.getSizes().size() == 2) {
            this.xBoundaries = ((ArrayDimensionDisplay)data.getDimensionDisplay().get(1)).getCellBoundaries();
            this.yBoundaries = ((ArrayDimensionDisplay)data.getDimensionDisplay().get(0)).getCellBoundaries();
            this.array2D = new Array2DDouble(data.getSizes(), ((ArrayDimensionDisplay)data.getDimensionDisplay().get(1)).isReversed(), ((ArrayDimensionDisplay)data.getDimensionDisplay().get(0)).isReversed());
        } else {
            throw new IllegalArgumentException("Array is 3D or more");
        }
        this.xRange = Ranges.range((double)this.xBoundaries.getDouble(0), (double)this.xBoundaries.getDouble(this.xBoundaries.size() - 1));
        this.yRange = Ranges.range((double)this.yBoundaries.getDouble(0), (double)this.yBoundaries.getDouble(this.yBoundaries.size() - 1));
        this.xCount = this.xBoundaries.size() - 1;
        this.yCount = this.yBoundaries.size() - 1;
        double low = data.getLowerDisplayLimit();
        double high = data.getUpperDisplayLimit();
        if (this.values instanceof ListByte) {
            if (low == high) {
                low = -128.0;
                high = 127.0;
            }
            low = Math.max(-128.0, low);
            high = Math.min(127.0, high);
        }
        this.displayRange = Ranges.range((double)low, (double)high);
    }

    public double getValue(int x, int y) {
        return this.values.getDouble(this.array2D.getIndex(x, y));
    }

    public Statistics getStatistics() {
        if (this.statistics == null) {
            this.statistics = StatisticsUtil.lazyStatisticsOf((CollectionNumber)this.values);
        }
        return this.statistics;
    }

    public Range getDisplayRange() {
        return this.displayRange;
    }

    public ListNumber getXBoundaries() {
        return this.xBoundaries;
    }

    public Range getXRange() {
        return this.xRange;
    }

    public int getXCount() {
        return this.xCount;
    }

    public ListNumber getYBoundaries() {
        return this.yBoundaries;
    }

    public Range getYRange() {
        return this.yRange;
    }

    public int getYCount() {
        return this.yCount;
    }
}

