/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.graphene;

import java.awt.image.BufferedImage;
import java.util.AbstractList;
import java.util.Collections;
import java.util.List;
import org.epics.graphene.MultiAxisLineGraph2DRenderer;
import org.epics.graphene.MultiAxisLineGraph2DRendererUpdate;
import org.epics.graphene.Point2DDataset;
import org.epics.graphene.Point2DDatasets;
import org.epics.pvmanager.QueueCollector;
import org.epics.pvmanager.ReadFunction;
import org.epics.pvmanager.graphene.ArgumentExpressions;
import org.epics.pvmanager.graphene.CheckedReadFunction;
import org.epics.pvmanager.graphene.DatasetConversions;
import org.epics.pvmanager.graphene.Graph2DResult;
import org.epics.pvmanager.graphene.GraphDataRange;
import org.epics.pvmanager.graphene.ReadFunctionArgument;
import org.epics.util.array.ListNumber;
import org.epics.util.stats.Range;
import org.epics.util.stats.Statistics;
import org.epics.util.stats.StatisticsUtil;
import org.epics.vtype.VImage;
import org.epics.vtype.VNumberArray;
import org.epics.vtype.VTable;
import org.epics.vtype.VType;
import org.epics.vtype.ValueUtil;

class MultiAxisLineGraph2DFunction
implements ReadFunction<Graph2DResult> {
    private ReadFunction<VType> tableData;
    private ReadFunctionArgument<List<String>> xColumnNames;
    private ReadFunctionArgument<List<String>> yColumnNames;
    private MultiAxisLineGraph2DRenderer renderer = new MultiAxisLineGraph2DRenderer(300, 200);
    private VImage previousImage;
    private final QueueCollector<MultiAxisLineGraph2DRendererUpdate> rendererUpdateQueue = new QueueCollector(100);

    MultiAxisLineGraph2DFunction(ReadFunction<?> tableData, ReadFunction<?> xColumnName, ReadFunction<?> yColumnName) {
        this.tableData = new CheckedReadFunction<VType>(tableData, "Data", VTable.class, VNumberArray.class);
        this.xColumnNames = ArgumentExpressions.stringArrayArgument(xColumnName, "X Columns");
        this.yColumnNames = ArgumentExpressions.stringArrayArgument(yColumnName, "Y Columns");
    }

    public QueueCollector<MultiAxisLineGraph2DRendererUpdate> getRendererUpdateQueue() {
        return this.rendererUpdateQueue;
    }

    public Graph2DResult readValue() {
        VType vType = (VType)this.tableData.readValue();
        this.xColumnNames.readNext();
        this.yColumnNames.readNext();
        if (vType == null || this.xColumnNames.isMissing() || this.yColumnNames.isMissing()) {
            return null;
        }
        final List<Point2DDataset> dataset = vType instanceof VNumberArray ? Collections.singletonList(Point2DDatasets.lineData((ListNumber)((VNumberArray)vType).getData())) : DatasetConversions.point2DDatasetsFromVTable((VTable)vType, this.xColumnNames.getValue(), this.yColumnNames.getValue());
        List updates = this.rendererUpdateQueue.readValue();
        for (MultiAxisLineGraph2DRendererUpdate rendererUpdate : updates) {
            this.renderer.update(rendererUpdate);
        }
        if (this.renderer.getImageHeight() == 0 && this.renderer.getImageWidth() == 0) {
            return null;
        }
        BufferedImage image = new BufferedImage(this.renderer.getImageWidth(), this.renderer.getImageHeight(), 5);
        this.renderer.draw(image.createGraphics(), dataset);
        this.previousImage = ValueUtil.toVImage((BufferedImage)image);
        Statistics xDataRange = StatisticsUtil.statisticsOf((List)new AbstractList<Statistics>(){

            @Override
            public Statistics get(int index) {
                return ((Point2DDataset)dataset.get(index)).getXStatistics();
            }

            @Override
            public int size() {
                return dataset.size();
            }
        });
        Statistics yDataRange = StatisticsUtil.statisticsOf((List)new AbstractList<Statistics>(){

            @Override
            public Statistics get(int index) {
                return ((Point2DDataset)dataset.get(index)).getYStatistics();
            }

            @Override
            public int size() {
                return dataset.size();
            }
        });
        return new Graph2DResult(vType, this.previousImage, new GraphDataRange(this.renderer.getXPlotRange(), (Range)xDataRange, this.renderer.getXAggregatedRange()), new GraphDataRange(this.renderer.getYPlotRange(), (Range)yDataRange, this.renderer.getYAggregatedRange()), -1);
    }
}

