/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.graphene;

import java.util.ArrayList;
import org.epics.pvmanager.ReadFunction;
import org.epics.vtype.ValueUtil;

public class CheckedReadFunction<T>
implements ReadFunction<T> {
    private final Class<T> clazz;
    private final Class<? extends T>[] classes;
    private final ReadFunction<?> arg;
    private final String argName;

    public CheckedReadFunction(ReadFunction<?> arg, String argName, Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException("Class can't be null");
        }
        this.clazz = clazz;
        this.classes = null;
        this.arg = arg;
        this.argName = argName;
    }

    @SafeVarargs
    public CheckedReadFunction(ReadFunction<?> arg, String argName, Class<? extends T> ... classes) {
        if (classes == null) {
            throw new NullPointerException("Classes can't be null");
        }
        this.clazz = null;
        this.classes = classes;
        this.arg = arg;
        this.argName = argName;
    }

    public T readValue() {
        Object obj = this.arg.readValue();
        if (obj == null) {
            return null;
        }
        if (this.clazz != null) {
            if (this.clazz.isInstance(obj)) {
                return this.clazz.cast(obj);
            }
            throw new RuntimeException(this.argName + " must be a " + this.clazz.getSimpleName() + " (was " + ValueUtil.typeOf((Object)obj).getSimpleName() + ")");
        }
        for (Class<T> clazz : this.classes) {
            if (!clazz.isInstance(obj)) continue;
            return clazz.cast(obj);
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<String> names = new ArrayList<String>();
        for (Class<T> clazz : this.classes) {
            names.add(clazz.getSimpleName());
        }
        throw new RuntimeException(this.argName + " must be one of " + ((Object)names).toString() + " (was " + ValueUtil.typeOf((Object)obj).getSimpleName() + ")");
    }
}

