/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.graphene;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.epics.graphene.Cell1DDataset;
import org.epics.graphene.Cell1DDatasets;
import org.epics.graphene.Cell2DDataset;
import org.epics.graphene.Point2DDataset;
import org.epics.graphene.Point2DDatasets;
import org.epics.graphene.Point3DWithLabelDataset;
import org.epics.graphene.Point3DWithLabelDatasets;
import org.epics.pvmanager.graphene.Cell2DDatasetFromVNumberArray;
import org.epics.util.array.ListDouble;
import org.epics.util.array.ListNumber;
import org.epics.util.array.ListNumbers;
import org.epics.util.stats.Range;
import org.epics.util.stats.Ranges;
import org.epics.vtype.ArrayDimensionDisplay;
import org.epics.vtype.Display;
import org.epics.vtype.VNumberArray;
import org.epics.vtype.VTable;
import org.epics.vtype.ValueUtil;

public class DatasetConversions {
    public static Point2DDataset point2DDatasetFromVTable(VTable vTable, String xColumn, String yColumn) {
        ListNumber xValues = ValueUtil.numericColumnOf((VTable)vTable, (String)xColumn);
        ListNumber yValues = ValueUtil.numericColumnOf((VTable)vTable, (String)yColumn);
        for (int i = 0; i < vTable.getColumnCount(); ++i) {
            if (!vTable.getColumnType(i).isPrimitive() || vTable.getColumnName(i).equals(xColumn) || vTable.getColumnName(i).equals(yColumn)) continue;
            if (xValues == null) {
                xValues = (ListNumber)vTable.getColumnData(i);
                continue;
            }
            if (yValues != null) continue;
            yValues = (ListNumber)vTable.getColumnData(i);
        }
        if (xValues == null || yValues == null) {
            throw new IllegalArgumentException("Couldn't find two numeric columns");
        }
        return Point2DDatasets.lineData((ListNumber)xValues, (ListNumber)yValues);
    }

    public static Point3DWithLabelDataset point3DDatasetFromVTable(VTable vTable, String xColumn, String yColumn, String sizeColumn, String colorColumn) {
        ListNumber xValues = ValueUtil.numericColumnOf((VTable)vTable, (String)xColumn);
        ListNumber yValues = ValueUtil.numericColumnOf((VTable)vTable, (String)yColumn);
        Object sizeValues = ValueUtil.numericColumnOf((VTable)vTable, (String)sizeColumn);
        List colorValues = ValueUtil.stringColumnOf((VTable)vTable, (String)colorColumn);
        if (xValues == null && yValues == null && sizeValues == null && colorValues == null) {
            for (int i = 0; i < vTable.getColumnCount(); ++i) {
                List list;
                if (vTable.getColumnType(i).isPrimitive()) {
                    if (xValues == null) {
                        xValues = (ListNumber)vTable.getColumnData(i);
                        continue;
                    }
                    if (yValues == null) {
                        yValues = (ListNumber)vTable.getColumnData(i);
                        continue;
                    }
                    if (sizeValues != null) continue;
                    sizeValues = (ListNumber)vTable.getColumnData(i);
                    continue;
                }
                if (!vTable.getColumnType(i).equals(String.class) || colorValues != null) continue;
                colorValues = list = (List)vTable.getColumnData(i);
            }
            if (xValues == null || yValues == null) {
                throw new IllegalArgumentException("Couldn't find two numeric columns for X and Y");
            }
        }
        if (xValues == null || yValues == null) {
            throw new IllegalArgumentException("X and Y must both be specified");
        }
        final int nValues = xValues.size();
        if (sizeValues == null) {
            sizeValues = new ListDouble(){

                public double getDouble(int index) {
                    return 0.0;
                }

                public int size() {
                    return nValues;
                }
            };
        }
        if (colorValues == null) {
            colorValues = Collections.nCopies(xValues.size(), "None");
        }
        return Point3DWithLabelDatasets.build((ListNumber)xValues, (ListNumber)yValues, (ListNumber)sizeValues, colorValues);
    }

    public static List<Point2DDataset> point2DDatasetsFromVTable(VTable vTable, List<String> xColumns, List<String> yColumns) {
        ArrayList<ListNumber> xValues = new ArrayList<ListNumber>();
        ArrayList<ListNumber> yValues = new ArrayList<ListNumber>();
        if (xColumns != null && yColumns != null) {
            for (String column : xColumns) {
                xValues.add(ValueUtil.numericColumnOf((VTable)vTable, (String)column));
            }
            for (String column : yColumns) {
                yValues.add(ValueUtil.numericColumnOf((VTable)vTable, (String)column));
            }
        } else if (xColumns == null && yColumns == null) {
            for (int i = 0; i < vTable.getColumnCount(); ++i) {
                if (!vTable.getColumnType(i).isPrimitive()) continue;
                yValues.add((ListNumber)vTable.getColumnData(i));
            }
        } else {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        if (xValues.isEmpty()) {
            ArrayList<Point2DDataset> datasets = new ArrayList<Point2DDataset>();
            for (int i = 0; i < yValues.size(); ++i) {
                datasets.add(Point2DDatasets.lineData((ListNumber)ListNumbers.linearList((double)0.0, (double)1.0, (int)((ListNumber)yValues.get(i)).size()), (ListNumber)((ListNumber)yValues.get(i))));
            }
            return datasets;
        }
        if (xValues.size() == yValues.size()) {
            ArrayList<Point2DDataset> datasets = new ArrayList<Point2DDataset>();
            for (int i = 0; i < xValues.size(); ++i) {
                datasets.add(Point2DDatasets.lineData((ListNumber)((ListNumber)xValues.get(i)), (ListNumber)((ListNumber)yValues.get(i))));
            }
            return datasets;
        }
        if (xValues.size() == 1) {
            ArrayList<Point2DDataset> datasets = new ArrayList<Point2DDataset>();
            for (int i = 0; i < yValues.size(); ++i) {
                datasets.add(Point2DDatasets.lineData((ListNumber)((ListNumber)xValues.get(0)), (ListNumber)((ListNumber)yValues.get(i))));
            }
            return datasets;
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static Cell2DDataset cell2DDatasetsFromVNumberArray(VNumberArray data) {
        return new Cell2DDatasetFromVNumberArray(data);
    }

    public static Range toRange(Display display) {
        if (display == null) {
            return null;
        }
        Double min = display.getLowerDisplayLimit();
        Double max = display.getUpperDisplayLimit();
        if (min != null && max != null) {
            return Ranges.range((double)min, (double)max);
        }
        return null;
    }

    public static Cell1DDataset cell1DDatasetsFromVNumberArray(VNumberArray data) {
        return Cell1DDatasets.datasetFrom((ListNumber)data.getData(), (ListNumber)((ArrayDimensionDisplay)data.getDimensionDisplay().get(0)).getCellBoundaries(), (Range)DatasetConversions.toRange((Display)data));
    }
}

