/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.graphene;

import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.List;
import org.epics.graphene.Cell2DDataset;
import org.epics.graphene.Graph2DRenderer;
import org.epics.graphene.GraphBuffer;
import org.epics.graphene.IntensityGraph2DRenderer;
import org.epics.graphene.IntensityGraph2DRendererUpdate;
import org.epics.pvmanager.QueueCollector;
import org.epics.pvmanager.ReadFunction;
import org.epics.pvmanager.graphene.CheckedReadFunction;
import org.epics.pvmanager.graphene.DatasetConversions;
import org.epics.pvmanager.graphene.Graph2DResult;
import org.epics.pvmanager.graphene.GraphDataRange;
import org.epics.util.array.ArrayInt;
import org.epics.util.array.ListDouble;
import org.epics.util.array.ListInt;
import org.epics.util.array.ListMath;
import org.epics.util.array.ListNumber;
import org.epics.vtype.Alarm;
import org.epics.vtype.ArrayDimensionDisplay;
import org.epics.vtype.Display;
import org.epics.vtype.Time;
import org.epics.vtype.VNumberArray;
import org.epics.vtype.VType;
import org.epics.vtype.ValueFactory;
import org.epics.vtype.ValueUtil;

class IntensityGraph2DFunction
implements ReadFunction<Graph2DResult> {
    private ReadFunction<VNumberArray> arrayData;
    private IntensityGraph2DRenderer renderer = new IntensityGraph2DRenderer(300, 200);
    private VNumberArray oldData;
    private Graph2DResult previousResult;
    private final QueueCollector<IntensityGraph2DRendererUpdate> rendererUpdateQueue = new QueueCollector(100);

    public IntensityGraph2DFunction(ReadFunction<?> arrayData) {
        this.arrayData = new CheckedReadFunction<VNumberArray>(arrayData, "Data", VNumberArray.class);
    }

    public QueueCollector<IntensityGraph2DRendererUpdate> getUpdateQueue() {
        return this.rendererUpdateQueue;
    }

    public Graph2DResult readValue() {
        VNumberArray data = (VNumberArray)this.arrayData.readValue();
        if (data == null) {
            return null;
        }
        List updates = this.getUpdateQueue().readValue();
        if (data == this.oldData && updates.isEmpty()) {
            return this.previousResult;
        }
        this.oldData = data;
        Cell2DDataset dataset = DatasetConversions.cell2DDatasetsFromVNumberArray(data);
        for (IntensityGraph2DRendererUpdate rendererUpdate : updates) {
            this.renderer.update(rendererUpdate);
        }
        if (this.renderer.getImageHeight() == 0 && this.renderer.getImageWidth() == 0) {
            return null;
        }
        GraphBuffer buffer = new GraphBuffer((Graph2DRenderer)this.renderer);
        this.renderer.draw(buffer, dataset);
        return new Graph2DResult((VType)data, ValueUtil.toVImage((BufferedImage)buffer.getImage()), new GraphDataRange(this.renderer.getXPlotRange(), dataset.getXRange(), dataset.getXRange()), new GraphDataRange(this.renderer.getYPlotRange(), dataset.getYRange(), dataset.getYRange()), -1, (VType)this.selectionData(data, this.renderer));
    }

    private VNumberArray selectionData(VNumberArray data, IntensityGraph2DRenderer renderer) {
        if (renderer.getXIndexSelectionRange() == null || renderer.getYIndexSelectionRange() == null) {
            return null;
        }
        ArrayDimensionDisplay xDisplay = (ArrayDimensionDisplay)data.getDimensionDisplay().get(1);
        int leftIndex = renderer.getXIndexSelectionRange().getMinimum().intValue();
        int rightIndex = renderer.getXIndexSelectionRange().getMaximum().intValue();
        final int xSize = rightIndex - leftIndex + 1;
        if (xDisplay.isReversed()) {
            leftIndex = data.getSizes().getInt(1) - 1 - leftIndex;
            rightIndex = data.getSizes().getInt(1) - 1 - rightIndex;
        }
        ArrayDimensionDisplay yDisplay = (ArrayDimensionDisplay)data.getDimensionDisplay().get(0);
        int bottomIndex = renderer.getYIndexSelectionRange().getMinimum().intValue();
        int topIndex = renderer.getYIndexSelectionRange().getMaximum().intValue();
        if (yDisplay.isReversed()) {
            bottomIndex = data.getSizes().getInt(0) - 1 - bottomIndex;
            topIndex = data.getSizes().getInt(0) - 1 - topIndex;
        }
        final int ySize = topIndex - bottomIndex + 1;
        return ValueFactory.newVNumberArray((ListNumber)new ListDouble(){

            public double getDouble(int index) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public int size() {
                return xSize * ySize;
            }
        }, (ListInt)new ArrayInt(new int[]{ySize, xSize}), Arrays.asList(ValueFactory.newDisplay((ListNumber)ListMath.limit((ListNumber)yDisplay.getCellBoundaries(), (int)bottomIndex, (int)(topIndex + 1)), (String)yDisplay.getUnits()), ValueFactory.newDisplay((ListNumber)ListMath.limit((ListNumber)xDisplay.getCellBoundaries(), (int)leftIndex, (int)(rightIndex + 1)), (String)yDisplay.getUnits())), (Alarm)data, (Time)data, (Display)data);
    }
}

