/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.graphene;

import java.awt.image.BufferedImage;
import java.util.List;
import org.epics.graphene.Point2DDataset;
import org.epics.graphene.Point2DDatasets;
import org.epics.graphene.SparklineGraph2DRenderer;
import org.epics.graphene.SparklineGraph2DRendererUpdate;
import org.epics.pvmanager.QueueCollector;
import org.epics.pvmanager.ReadFunction;
import org.epics.pvmanager.graphene.ArgumentExpressions;
import org.epics.pvmanager.graphene.CheckedReadFunction;
import org.epics.pvmanager.graphene.DatasetConversions;
import org.epics.pvmanager.graphene.Graph2DResult;
import org.epics.pvmanager.graphene.GraphDataRange;
import org.epics.pvmanager.graphene.ReadFunctionArgument;
import org.epics.util.array.ListNumber;
import org.epics.util.stats.Range;
import org.epics.vtype.VImage;
import org.epics.vtype.VNumberArray;
import org.epics.vtype.VTable;
import org.epics.vtype.VType;
import org.epics.vtype.ValueUtil;

class SparklineGraph2DFunction
implements ReadFunction<Graph2DResult> {
    private ReadFunction<VType> tableData;
    private ReadFunctionArgument<String> xColumnName;
    private ReadFunctionArgument<String> yColumnName;
    private SparklineGraph2DRenderer renderer = new SparklineGraph2DRenderer(300, 200);
    private VImage previousImage;
    private final QueueCollector<SparklineGraph2DRendererUpdate> rendererUpdateQueue = new QueueCollector(100);

    SparklineGraph2DFunction(ReadFunction<?> tableData, ReadFunction<?> xColumnName, ReadFunction<?> yColumnName) {
        this.tableData = new CheckedReadFunction<VType>(tableData, "Data", VTable.class, VNumberArray.class);
        this.xColumnName = ArgumentExpressions.stringArgument(xColumnName, "X Column");
        this.yColumnName = ArgumentExpressions.stringArgument(yColumnName, "Y Column");
    }

    public QueueCollector<SparklineGraph2DRendererUpdate> getRendererUpdateQueue() {
        return this.rendererUpdateQueue;
    }

    public Graph2DResult readValue() {
        VType vType = (VType)this.tableData.readValue();
        this.xColumnName.readNext();
        this.yColumnName.readNext();
        if (vType == null || this.xColumnName.isMissing() || this.yColumnName.isMissing()) {
            return null;
        }
        Point2DDataset dataset = vType instanceof VNumberArray ? Point2DDatasets.lineData((ListNumber)((VNumberArray)vType).getData()) : DatasetConversions.point2DDatasetFromVTable((VTable)vType, this.xColumnName.getValue(), this.yColumnName.getValue());
        List updates = this.rendererUpdateQueue.readValue();
        for (SparklineGraph2DRendererUpdate rendererUpdate : updates) {
            this.renderer.update(rendererUpdate);
        }
        if (this.renderer.getImageHeight() == 0 && this.renderer.getImageWidth() == 0) {
            return null;
        }
        BufferedImage image = new BufferedImage(this.renderer.getImageWidth(), this.renderer.getImageHeight(), 5);
        this.renderer.draw(image.createGraphics(), dataset);
        this.previousImage = ValueUtil.toVImage((BufferedImage)image);
        return new Graph2DResult(vType, this.previousImage, new GraphDataRange(this.renderer.getXPlotRange(), (Range)dataset.getXStatistics(), this.renderer.getXAggregatedRange()), new GraphDataRange(this.renderer.getYPlotRange(), (Range)dataset.getYStatistics(), this.renderer.getYAggregatedRange()), -1);
    }
}

