/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.jca;

import gov.aps.jca.Context;
import gov.aps.jca.jni.JNIContext;
import java.util.concurrent.ExecutorService;
import java.util.logging.Logger;
import org.epics.pvmanager.ChannelHandler;
import org.epics.pvmanager.DataSource;
import org.epics.pvmanager.jca.JCAChannelHandler;
import org.epics.pvmanager.jca.JCADataSourceBuilder;
import org.epics.pvmanager.jca.JCATypeSupport;
import org.epics.pvmanager.jca.JCAVTypeAdapterSet;
import org.epics.pvmanager.util.Executors;
import org.epics.pvmanager.vtype.DataTypeSupport;

public class JCADataSource
extends DataSource {
    private static final Logger log;
    private final Context ctxt;
    private final int monitorMask;
    private final boolean varArraySupported;
    private final boolean dbePropertySupported;
    private final JCATypeSupport typeSupport;
    private final boolean rtypValueOnly;
    private final boolean honorZeroPrecision;
    private final ExecutorService contextSwitch;

    public JCADataSource() {
        this(new JCADataSourceBuilder());
    }

    @Deprecated
    public JCADataSource(Context jcaContext, int monitorMask) {
        this(new JCADataSourceBuilder().jcaContext(jcaContext).monitorMask(monitorMask));
    }

    @Deprecated
    public JCADataSource(String className, int monitorMask) {
        this(new JCADataSourceBuilder().jcaContextClass(className).monitorMask(monitorMask));
    }

    @Deprecated
    public JCADataSource(Context jcaContext, int monitorMask, JCATypeSupport typeSupport) {
        this(new JCADataSourceBuilder().jcaContext(jcaContext).monitorMask(monitorMask).typeSupport(typeSupport));
    }

    @Deprecated
    public JCADataSource(Context jcaContext, int monitorMask, JCATypeSupport typeSupport, boolean dbePropertySupported, boolean varArraySupported) {
        this(new JCADataSourceBuilder().jcaContext(jcaContext).monitorMask(monitorMask).typeSupport(typeSupport).dbePropertySupported(dbePropertySupported).varArraySupported(varArraySupported));
    }

    protected JCADataSource(JCADataSourceBuilder builder) {
        super(true);
        this.ctxt = builder.jcaContext == null ? JCADataSourceBuilder.createContext("com.cosylab.epics.caj.CAJContext") : builder.jcaContext;
        this.typeSupport = builder.typeSupport == null ? new JCATypeSupport(new JCAVTypeAdapterSet()) : builder.typeSupport;
        this.varArraySupported = builder.varArraySupported == null ? JCADataSourceBuilder.isVarArraySupported(this.ctxt) : builder.varArraySupported;
        this.monitorMask = builder.monitorMask;
        this.dbePropertySupported = builder.dbePropertySupported;
        this.rtypValueOnly = builder.rtypValueOnly;
        this.honorZeroPrecision = builder.honorZeroPrecision;
        this.contextSwitch = this.useContextSwitchForAccessRightCallback() ? java.util.concurrent.Executors.newSingleThreadExecutor(Executors.namedPool((String)"PVMgr JCA Workaround ")) : null;
    }

    public void close() {
        super.close();
        this.ctxt.dispose();
    }

    public Context getContext() {
        return this.ctxt;
    }

    public int getMonitorMask() {
        return this.monitorMask;
    }

    public boolean isDbePropertySupported() {
        return this.dbePropertySupported;
    }

    protected ChannelHandler createChannel(String channelName) {
        return new JCAChannelHandler(channelName, this);
    }

    JCATypeSupport getTypeSupport() {
        return this.typeSupport;
    }

    public boolean isVarArraySupported() {
        return this.varArraySupported;
    }

    public boolean isRtypValueOnly() {
        return this.rtypValueOnly;
    }

    public boolean isHonorZeroPrecision() {
        return this.honorZeroPrecision;
    }

    @Deprecated
    public static boolean isVarArraySupported(Context context) {
        return JCADataSourceBuilder.isVarArraySupported(context);
    }

    final boolean useContextSwitchForAccessRightCallback() {
        return this.ctxt instanceof JNIContext;
    }

    ExecutorService getContextSwitch() {
        return this.contextSwitch;
    }

    static {
        DataTypeSupport.install();
        log = Logger.getLogger(JCADataSource.class.getName());
    }
}

