/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.jca;

import gov.aps.jca.Channel;
import gov.aps.jca.dbr.DBRType;
import org.epics.pvmanager.jca.JCAChannelHandler;
import org.epics.pvmanager.jca.JCADataSource;

public class JCAConnectionPayload {
    private final JCADataSource jcaDataSource;
    private final Channel channel;
    private final boolean connected;
    private final boolean longString;
    private final DBRType fieldType;

    public JCAConnectionPayload(JCAChannelHandler channleHandler, Channel channel, JCAConnectionPayload previousPayload) {
        this.jcaDataSource = channleHandler.getJcaDataSource();
        this.channel = channel;
        this.connected = channel != null && channel.getConnectionState() == Channel.ConnectionState.CONNECTED;
        this.longString = channleHandler.isLongString();
        this.fieldType = channel.getFieldType().getClass() == null && previousPayload != null ? previousPayload.fieldType : channel.getFieldType();
    }

    public JCADataSource getJcaDataSource() {
        return this.jcaDataSource;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public DBRType getFieldType() {
        return this.fieldType;
    }

    public boolean isChannelConnected() {
        return this.connected;
    }

    public boolean isWriteConnected() {
        return this.isChannelConnected() && this.channel.getWriteAccess();
    }

    public boolean isLongString() {
        return this.longString;
    }

    public String toString() {
        return "JCAConnection [connected: " + this.isChannelConnected() + " writeConnected: " + this.isWriteConnected() + " channel: " + this.channel + "]";
    }
}

