/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.jca;

import gov.aps.jca.dbr.CTRL;
import gov.aps.jca.dbr.PRECISION;
import gov.aps.jca.dbr.TIME;
import java.text.NumberFormat;
import org.epics.pvmanager.jca.JCAConnectionPayload;
import org.epics.pvmanager.jca.VMetadata;
import org.epics.util.text.NumberFormats;
import org.epics.vtype.Display;

class VNumberMetadata<TValue extends TIME, TMetadata extends CTRL>
extends VMetadata<TValue>
implements Display {
    private final TMetadata metadata;
    private final boolean honorZeroPrecision;

    VNumberMetadata(TValue dbrValue, TMetadata metadata, JCAConnectionPayload connPayload) {
        super(dbrValue, connPayload);
        this.metadata = metadata;
        this.honorZeroPrecision = connPayload.getJcaDataSource().isHonorZeroPrecision();
    }

    public Double getLowerDisplayLimit() {
        return (Double)this.metadata.getLowerDispLimit();
    }

    public Double getLowerCtrlLimit() {
        return (Double)this.metadata.getLowerCtrlLimit();
    }

    public Double getLowerAlarmLimit() {
        return (Double)this.metadata.getLowerAlarmLimit();
    }

    public Double getLowerWarningLimit() {
        return (Double)this.metadata.getLowerWarningLimit();
    }

    public String getUnits() {
        return this.metadata.getUnits();
    }

    public NumberFormat getFormat() {
        int precision = -1;
        if (this.metadata instanceof PRECISION) {
            precision = ((PRECISION)this.metadata).getPrecision();
        }
        if (precision < 0) {
            return NumberFormats.toStringFormat();
        }
        if (precision == 0) {
            if (this.honorZeroPrecision) {
                return NumberFormats.format((int)0);
            }
            return NumberFormats.toStringFormat();
        }
        return NumberFormats.format((int)precision);
    }

    public Double getUpperWarningLimit() {
        return (Double)this.metadata.getUpperWarningLimit();
    }

    public Double getUpperAlarmLimit() {
        return (Double)this.metadata.getUpperAlarmLimit();
    }

    public Double getUpperCtrlLimit() {
        return (Double)this.metadata.getUpperCtrlLimit();
    }

    public Double getUpperDisplayLimit() {
        return (Double)this.metadata.getUpperDispLimit();
    }
}

