/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.jca;

import gov.aps.jca.CAException;
import gov.aps.jca.Context;
import gov.aps.jca.JCALibrary;
import gov.aps.jca.jni.JNIContext;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.epics.pvmanager.jca.JCADataSource;
import org.epics.pvmanager.jca.JCATypeSupport;

public class JCADataSourceBuilder {
    private static final Logger log = Logger.getLogger(JCADataSource.class.getName());
    Context jcaContext;
    int monitorMask = 5;
    JCATypeSupport typeSupport;
    boolean dbePropertySupported = false;
    Boolean varArraySupported;
    boolean rtypValueOnly = false;
    boolean honorZeroPrecision = true;

    public JCADataSourceBuilder jcaContextClass(String className) {
        if (this.jcaContext != null) {
            throw new IllegalStateException("You should call either jcaContextClass or jcaContext once.");
        }
        this.jcaContext = JCADataSourceBuilder.createContext(className);
        return this;
    }

    public JCADataSourceBuilder jcaContext(Context jcaContext) {
        if (jcaContext == null) {
            throw new IllegalStateException("You should call once either jcaContextClass or jcaContext.");
        }
        this.jcaContext = jcaContext;
        return this;
    }

    public JCADataSourceBuilder monitorMask(int monitorMask) {
        this.monitorMask = monitorMask;
        return this;
    }

    public JCADataSourceBuilder typeSupport(JCATypeSupport typeSupport) {
        this.typeSupport = typeSupport;
        return this;
    }

    public JCADataSourceBuilder dbePropertySupported(boolean dbePropertySupported) {
        this.dbePropertySupported = dbePropertySupported;
        return this;
    }

    public JCADataSourceBuilder varArraySupported(boolean varArraySupported) {
        this.varArraySupported = varArraySupported;
        return this;
    }

    public JCADataSourceBuilder rtypValueOnly(boolean rtypValueOnly) {
        this.rtypValueOnly = rtypValueOnly;
        return this;
    }

    public JCADataSourceBuilder honorZeroPrecision(boolean honorZeroPrecision) {
        this.honorZeroPrecision = honorZeroPrecision;
        return this;
    }

    public JCADataSource build() {
        return new JCADataSource(this);
    }

    static boolean isVarArraySupported(Context context) {
        try {
            Class<?> cajClazz = Class.forName("com.cosylab.epics.caj.CAJContext");
            if (cajClazz.isInstance(context)) {
                return context.getVersion().getMajorVersion() > 1 || context.getVersion().getMinorVersion() > 1 || context.getVersion().getMaintenanceVersion() > 9;
            }
        }
        catch (ClassNotFoundException ex) {
            // empty catch block
        }
        if (context instanceof JNIContext) {
            try {
                Class<?> jniClazz = Class.forName("gov.aps.jca.jni.JNI");
                final Method method = jniClazz.getDeclaredMethod("_ca_getRevision", new Class[0]);
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        method.setAccessible(true);
                        return null;
                    }
                });
                Integer integer = (Integer)method.invoke(null, new Object[0]);
                return integer >= 13;
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, "Couldn't detect varArraySupported", ex);
            }
        }
        return true;
    }

    static Context createContext(String className) {
        try {
            JCALibrary jca = JCALibrary.getInstance();
            return jca.createContext(className);
        }
        catch (CAException ex) {
            log.log(Level.SEVERE, "JCA context creation failed", ex);
            throw new RuntimeException("JCA context creation failed", ex);
        }
    }
}

