/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.jca;

import gov.aps.jca.ValuedEnum;
import gov.aps.jca.dbr.Severity;
import gov.aps.jca.dbr.Status;
import gov.aps.jca.dbr.TimeStamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.epics.util.time.TimeDuration;
import org.epics.util.time.Timestamp;
import org.epics.vtype.AlarmSeverity;

class DataUtils {
    private static final Logger log = Logger.getLogger(DataUtils.class.getName());
    static long TS_EPOCH_SEC_PAST_1970 = 631152000L;
    private static final List<String> epicsPossibleStatus;

    DataUtils() {
    }

    static Timestamp timestampOf(TimeStamp epicsTimeStamp) {
        if (epicsTimeStamp == null) {
            return null;
        }
        return Timestamp.of((long)(epicsTimeStamp.secPastEpoch() + TS_EPOCH_SEC_PAST_1970), (int)0).plus(TimeDuration.ofNanos((long)epicsTimeStamp.nsec()));
    }

    static AlarmSeverity fromEpics(Severity severity) {
        if (Severity.NO_ALARM.isEqualTo((ValuedEnum)severity)) {
            return AlarmSeverity.NONE;
        }
        if (Severity.MINOR_ALARM.isEqualTo((ValuedEnum)severity)) {
            return AlarmSeverity.MINOR;
        }
        if (Severity.MAJOR_ALARM.isEqualTo((ValuedEnum)severity)) {
            return AlarmSeverity.MAJOR;
        }
        if (Severity.INVALID_ALARM.isEqualTo((ValuedEnum)severity)) {
            return AlarmSeverity.INVALID;
        }
        return AlarmSeverity.UNDEFINED;
    }

    static List<String> epicsPossibleStatus() {
        return epicsPossibleStatus;
    }

    static boolean isTimeValid(TimeStamp timeStamp) {
        if (timeStamp == null) {
            return false;
        }
        long sec = timeStamp.secPastEpoch() + TS_EPOCH_SEC_PAST_1970;
        if (sec == 0L || sec == TS_EPOCH_SEC_PAST_1970) {
            return false;
        }
        long nanosec = timeStamp.nsec();
        return nanosec >= 0L && nanosec <= 999999999L;
    }

    static {
        ArrayList<String> mutableList = new ArrayList<String>();
        Status aStatus = Status.forValue((int)0);
        while (aStatus != null) {
            mutableList.add(aStatus.getName());
            aStatus = Status.forValue((int)(aStatus.getValue() + 1));
        }
        epicsPossibleStatus = Collections.unmodifiableList(mutableList);
    }
}

