/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.jca;

import gov.aps.jca.Channel;
import gov.aps.jca.dbr.DBR;
import gov.aps.jca.dbr.DBR_String;
import gov.aps.jca.dbr.DBR_TIME_String;
import gov.aps.jca.dbr.Severity;
import gov.aps.jca.dbr.Status;
import gov.aps.jca.dbr.TimeStamp;
import gov.aps.jca.event.MonitorEvent;

public class JCAMessagePayload {
    private final DBR metadata;
    private final MonitorEvent event;

    JCAMessagePayload(DBR metadata, MonitorEvent event) {
        if (event != null && event.getDBR() instanceof DBR_String && !(event.getDBR() instanceof DBR_TIME_String)) {
            DBR_String originalValue = (DBR_String)event.getDBR();
            DBR_TIME_String value = new DBR_TIME_String(originalValue.getStringValue());
            value.setSeverity(Severity.NO_ALARM);
            value.setStatus(Status.NO_ALARM);
            value.setTimeStamp(new TimeStamp());
            event = new MonitorEvent((Channel)event.getSource(), (DBR)value, event.getStatus());
        }
        this.metadata = metadata;
        this.event = event;
    }

    public MonitorEvent getEvent() {
        return this.event;
    }

    public DBR getMetadata() {
        return this.metadata;
    }

    public String toString() {
        DBR value = null;
        if (this.event != null) {
            value = this.event.getDBR();
        }
        return "Metadata " + this.metadata + " value " + value;
    }
}

