/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.jca;

import gov.aps.jca.CAException;
import gov.aps.jca.Channel;
import gov.aps.jca.Monitor;
import gov.aps.jca.dbr.DBR;
import gov.aps.jca.dbr.DBRType;
import gov.aps.jca.dbr.DBR_CTRL_Double;
import gov.aps.jca.dbr.DBR_LABELS_Enum;
import gov.aps.jca.dbr.DBR_String;
import gov.aps.jca.dbr.DBR_TIME_Byte;
import gov.aps.jca.dbr.DBR_TIME_Double;
import gov.aps.jca.dbr.DBR_TIME_Enum;
import gov.aps.jca.dbr.DBR_TIME_Float;
import gov.aps.jca.dbr.DBR_TIME_Int;
import gov.aps.jca.dbr.DBR_TIME_Short;
import gov.aps.jca.dbr.DBR_TIME_String;
import gov.aps.jca.event.AccessRightsEvent;
import gov.aps.jca.event.AccessRightsListener;
import gov.aps.jca.event.ConnectionEvent;
import gov.aps.jca.event.ConnectionListener;
import gov.aps.jca.event.GetEvent;
import gov.aps.jca.event.GetListener;
import gov.aps.jca.event.MonitorEvent;
import gov.aps.jca.event.MonitorListener;
import gov.aps.jca.event.PutEvent;
import gov.aps.jca.event.PutListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.epics.pvmanager.ChannelHandlerWriteSubscription;
import org.epics.pvmanager.ChannelWriteCallback;
import org.epics.pvmanager.MultiplexedChannelHandler;
import org.epics.pvmanager.ValueCache;
import org.epics.pvmanager.jca.JCAConnectionPayload;
import org.epics.pvmanager.jca.JCADataSource;
import org.epics.pvmanager.jca.JCAMessagePayload;
import org.epics.pvmanager.jca.JCATypeAdapter;
import org.epics.util.array.CollectionNumber;
import org.epics.util.array.CollectionNumbers;
import org.epics.util.array.ListNumber;

class JCAChannelHandler
extends MultiplexedChannelHandler<JCAConnectionPayload, JCAMessagePayload> {
    private static final int LARGE_ARRAY = 100000;
    private final JCADataSource jcaDataSource;
    private final String jcaChannelName;
    private volatile Channel channel;
    private volatile boolean needsMonitor;
    private Monitor valueMonitor;
    private Monitor metadataMonitor;
    private volatile boolean largeArray = false;
    private volatile boolean sentReadOnlyException = false;
    private final boolean putCallback;
    private final boolean longString;
    private final AtomicBoolean needsAccessChangeListener = new AtomicBoolean(false);
    public static Pattern longStringPattern = Pattern.compile(".+\\..*\\$.*");
    private static final Pattern hasOptions = Pattern.compile("(.*) (\\{.*\\})");
    private static final Logger log = Logger.getLogger(JCAChannelHandler.class.getName());
    private final ConnectionListener connectionListener = new ConnectionListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void connectionChanged(ConnectionEvent ev) {
            Channel channel;
            JCAChannelHandler jCAChannelHandler = JCAChannelHandler.this;
            synchronized (jCAChannelHandler) {
                try {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "JCA connectionChanged for channel {0} event {1}", new Object[]{JCAChannelHandler.this.getChannelName(), ev});
                    }
                    channel = (Channel)ev.getSource();
                    if (ev.isConnected() && channel.getElementCount() >= 100000 && !JCAChannelHandler.this.largeArray) {
                        JCAChannelHandler.this.disconnect();
                        JCAChannelHandler.this.largeArray = true;
                        JCAChannelHandler.this.connect();
                        return;
                    }
                    JCAChannelHandler.this.processConnection(new JCAConnectionPayload(JCAChannelHandler.this, channel, (JCAConnectionPayload)JCAChannelHandler.this.getConnectionPayload()));
                    if (ev.isConnected()) {
                        if (!channel.getWriteAccess() && !JCAChannelHandler.this.sentReadOnlyException) {
                            JCAChannelHandler.this.reportExceptionToAllWriters(JCAChannelHandler.this.createReadOnlyException());
                            JCAChannelHandler.this.sentReadOnlyException = true;
                        }
                        JCAChannelHandler.this.setup(channel);
                    } else {
                        JCAChannelHandler.this.resetMessage();
                        JCAChannelHandler.this.sentReadOnlyException = false;
                        JCAChannelHandler.this.needsMonitor = true;
                    }
                }
                catch (Exception ex) {
                    JCAChannelHandler.this.reportExceptionToAllReadersAndWriters(ex);
                }
            }
            boolean addListener = JCAChannelHandler.this.needsAccessChangeListener.getAndSet(false);
            if (addListener) {
                try {
                    channel = (Channel)ev.getSource();
                    channel.addAccessRightsListener(new AccessRightsListener(){

                        public void accessRightsChanged(AccessRightsEvent ev) {
                            if (log.isLoggable(Level.FINEST)) {
                                log.log(Level.FINEST, "JCA accessRightsChanged for channel {0} event {1}", new Object[]{JCAChannelHandler.this.getChannelName(), ev});
                            }
                            final Channel channel = (Channel)ev.getSource();
                            Runnable task = new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    JCAChannelHandler jCAChannelHandler = JCAChannelHandler.this;
                                    synchronized (jCAChannelHandler) {
                                        JCAChannelHandler.this.processConnection(new JCAConnectionPayload(JCAChannelHandler.this, channel, (JCAConnectionPayload)JCAChannelHandler.this.getConnectionPayload()));
                                        if (!JCAChannelHandler.this.sentReadOnlyException && !channel.getWriteAccess()) {
                                            JCAChannelHandler.this.reportExceptionToAllWriters(JCAChannelHandler.this.createReadOnlyException());
                                            JCAChannelHandler.this.sentReadOnlyException = true;
                                        }
                                    }
                                }
                            };
                            if (JCAChannelHandler.this.jcaDataSource.useContextSwitchForAccessRightCallback()) {
                                JCAChannelHandler.this.jcaDataSource.getContextSwitch().submit(task);
                            } else {
                                task.run();
                            }
                        }
                    });
                }
                catch (Exception ex) {
                    JCAChannelHandler.this.reportExceptionToAllReadersAndWriters(ex);
                }
            }
        }
    };
    private final MonitorListener monitorListener = new MonitorListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void monitorChanged(MonitorEvent event) {
            JCAChannelHandler jCAChannelHandler = JCAChannelHandler.this;
            synchronized (jCAChannelHandler) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "JCA value monitorChanged for channel {0} value {1}, event {2}", new Object[]{JCAChannelHandler.this.getChannelName(), JCAChannelHandler.this.toStringDBR(event.getDBR()), event});
                }
                DBR metadata = null;
                if (JCAChannelHandler.this.getLastMessagePayload() != null) {
                    metadata = ((JCAMessagePayload)JCAChannelHandler.this.getLastMessagePayload()).getMetadata();
                }
                JCAChannelHandler.this.processMessage(new JCAMessagePayload(metadata, event));
            }
        }
    };
    private final MonitorListener metadataListener = new MonitorListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void monitorChanged(MonitorEvent ev) {
            JCAChannelHandler jCAChannelHandler = JCAChannelHandler.this;
            synchronized (jCAChannelHandler) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "JCA metadata monitorChanged for channel {0} event {1}", new Object[]{JCAChannelHandler.this.getChannelName(), ev});
                }
                MonitorEvent event = null;
                if (JCAChannelHandler.this.getLastMessagePayload() != null) {
                    event = ((JCAMessagePayload)JCAChannelHandler.this.getLastMessagePayload()).getEvent();
                }
                JCAChannelHandler.this.processMessage(new JCAMessagePayload(ev.getDBR(), event));
            }
        }
    };
    static Pattern rtypeStringPattern = Pattern.compile(".+\\.RTYP.*");

    public JCAChannelHandler(String channelName, JCADataSource jcaDataSource) {
        super(channelName);
        this.setProcessMessageOnReconnect(false);
        this.jcaDataSource = jcaDataSource;
        boolean longStringName = longStringPattern.matcher(channelName).matches();
        Matcher matcher = hasOptions.matcher(this.getChannelName());
        if (matcher.matches()) {
            String clientOptions;
            this.jcaChannelName = matcher.group(1);
            switch (clientOptions = matcher.group(2)) {
                case "{\"putCallback\":true}": {
                    this.putCallback = true;
                    this.longString = longStringName;
                    break;
                }
                case "{\"putCallback\":false}": {
                    this.putCallback = false;
                    this.longString = longStringName;
                    break;
                }
                case "{\"longString\":true}": {
                    this.putCallback = false;
                    this.longString = true;
                    break;
                }
                case "{\"longString\":false}": {
                    this.putCallback = false;
                    this.longString = false;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Option not recognized for " + this.getChannelName());
                }
            }
        } else {
            this.longString = longStringName;
            this.putCallback = false;
            this.jcaChannelName = channelName;
        }
    }

    public boolean isPutCallback() {
        return this.putCallback;
    }

    public boolean isLongString() {
        return this.longString;
    }

    public JCADataSource getJcaDataSource() {
        return this.jcaDataSource;
    }

    public String getJcaChannelName() {
        return this.jcaChannelName;
    }

    protected JCATypeAdapter findTypeAdapter(ValueCache<?> cache, JCAConnectionPayload connPayload) {
        return this.jcaDataSource.getTypeSupport().find(cache, connPayload);
    }

    public synchronized void connect() {
        this.needsMonitor = true;
        this.needsAccessChangeListener.set(true);
        try {
            this.channel = this.largeArray ? this.jcaDataSource.getContext().createChannel(this.getJcaChannelName(), this.connectionListener, (short)0) : this.jcaDataSource.getContext().createChannel(this.getJcaChannelName(), this.connectionListener, (short)1);
        }
        catch (CAException ex) {
            throw new RuntimeException("JCA Connection failed", ex);
        }
    }

    private void putWithCallback(Object newValue, final ChannelWriteCallback callback) throws CAException {
        PutListener listener = new PutListener(){

            public void putCompleted(PutEvent ev) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "JCA putCompleted for channel {0} event {1}", new Object[]{JCAChannelHandler.this.getChannelName(), ev});
                }
                if (ev.getStatus().isSuccessful()) {
                    callback.channelWritten(null);
                } else {
                    callback.channelWritten(new Exception(ev.toString()));
                }
            }
        };
        if (newValue instanceof ListNumber) {
            ListNumber data = (ListNumber)newValue;
            Object wrappedArray = CollectionNumbers.wrappedArray((CollectionNumber)data);
            newValue = wrappedArray == null ? (Object)CollectionNumbers.doubleArrayCopyOf((CollectionNumber)data) : wrappedArray;
        }
        if (newValue instanceof String) {
            if (this.isLongString()) {
                this.channel.put(JCAChannelHandler.toBytes(newValue.toString()), listener);
            } else if (this.channel.getFieldType().isBYTE() && this.channel.getElementCount() > 1) {
                log.warning("You are writing the String " + newValue + " to BYTE channel " + this.getChannelName() + ": use {\"longString\":true} for support");
                this.channel.put(JCAChannelHandler.toBytes(newValue.toString()), listener);
            } else {
                this.channel.put(newValue.toString(), listener);
            }
        } else if (newValue instanceof byte[]) {
            this.channel.put((byte[])newValue, listener);
        } else if (newValue instanceof short[]) {
            this.channel.put((short[])newValue, listener);
        } else if (newValue instanceof int[]) {
            this.channel.put((int[])newValue, listener);
        } else if (newValue instanceof float[]) {
            this.channel.put((float[])newValue, listener);
        } else if (newValue instanceof double[]) {
            this.channel.put((double[])newValue, listener);
        } else if (newValue instanceof Byte || newValue instanceof Short || newValue instanceof Integer || newValue instanceof Long) {
            this.channel.put((float)((Number)newValue).longValue(), listener);
        } else if (newValue instanceof Float || newValue instanceof Double) {
            this.channel.put(((Number)newValue).doubleValue(), listener);
        } else {
            throw new RuntimeException("Unsupported type for CA: " + newValue.getClass());
        }
        this.jcaDataSource.getContext().flushIO();
    }

    private void put(Object newValue, ChannelWriteCallback callback) throws CAException {
        int i;
        Object[] val;
        if (newValue instanceof ListNumber) {
            ListNumber data = (ListNumber)newValue;
            Object wrappedArray = CollectionNumbers.wrappedArray((CollectionNumber)data);
            newValue = wrappedArray == null ? (Object)CollectionNumbers.doubleArrayCopyOf((CollectionNumber)data) : wrappedArray;
        }
        if (newValue instanceof Double[]) {
            log.warning("You are writing a Double[] to channel " + this.getChannelName() + ": use org.epics.util.array.ListDouble instead");
            Double[] dbl = (Double[])newValue;
            val = new double[dbl.length];
            for (i = 0; i < val.length; ++i) {
                val[i] = dbl[i];
            }
            newValue = val;
        }
        if (newValue instanceof Integer[]) {
            log.warning("You are writing a Integer[] to channel " + this.getChannelName() + ": use org.epics.util.array.ListInt instead");
            Integer[] ival = (Integer[])newValue;
            val = new int[ival.length];
            for (i = 0; i < val.length; ++i) {
                val[i] = ival[i].intValue();
            }
            newValue = val;
        }
        if (newValue instanceof String) {
            if (this.isLongString()) {
                this.channel.put(JCAChannelHandler.toBytes(newValue.toString()));
            } else if (this.channel.getFieldType().isBYTE() && this.channel.getElementCount() > 1) {
                log.warning("You are writing the String " + newValue + " to BYTE channel " + this.getChannelName() + ": use {\"longString\":true} for support");
                this.channel.put(JCAChannelHandler.toBytes(newValue.toString()));
            } else {
                this.channel.put(newValue.toString());
            }
        } else if (newValue instanceof byte[]) {
            this.channel.put((byte[])newValue);
        } else if (newValue instanceof short[]) {
            this.channel.put((short[])newValue);
        } else if (newValue instanceof int[]) {
            this.channel.put((int[])newValue);
        } else if (newValue instanceof float[]) {
            this.channel.put((float[])newValue);
        } else if (newValue instanceof double[]) {
            this.channel.put((double[])newValue);
        } else if (newValue instanceof Byte || newValue instanceof Short || newValue instanceof Integer || newValue instanceof Long) {
            this.channel.put((float)((Number)newValue).longValue());
        } else if (newValue instanceof Float || newValue instanceof Double) {
            this.channel.put(((Number)newValue).doubleValue());
        } else {
            callback.channelWritten(new Exception(new RuntimeException("Unsupported type for CA: " + newValue.getClass())));
            return;
        }
        this.jcaDataSource.getContext().flushIO();
        callback.channelWritten(null);
    }

    private void setup(Channel channel) throws CAException {
        DBRType metaType = this.metadataFor(channel);
        if (metaType != null) {
            channel.get(metaType, 1, new GetListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void getCompleted(GetEvent ev) {
                    JCAChannelHandler jCAChannelHandler = JCAChannelHandler.this;
                    synchronized (jCAChannelHandler) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "JCA metadata getCompleted for channel {0} event {1}", new Object[]{JCAChannelHandler.this.getChannelName(), ev});
                        }
                        MonitorEvent event = null;
                        if (JCAChannelHandler.this.getLastMessagePayload() != null) {
                            event = ((JCAMessagePayload)JCAChannelHandler.this.getLastMessagePayload()).getEvent();
                        }
                        JCAChannelHandler.this.processMessage(new JCAMessagePayload(ev.getDBR(), event));
                    }
                }
            });
        }
        if (this.needsMonitor) {
            if (this.valueMonitor != null) {
                this.valueMonitor.removeMonitorListener(this.monitorListener);
                this.valueMonitor.clear();
                this.valueMonitor = null;
            }
            this.valueMonitor = channel.addMonitor(this.valueTypeFor(channel), this.countFor(channel), this.jcaDataSource.getMonitorMask(), this.monitorListener);
            this.needsMonitor = false;
        }
        if (this.metadataMonitor != null) {
            this.metadataMonitor.removeMonitorListener(this.metadataListener);
            this.metadataMonitor.clear();
            this.metadataMonitor = null;
        }
        if (this.jcaDataSource.isDbePropertySupported() && metaType != null) {
            this.metadataMonitor = channel.addMonitor(metaType, 1, 8, this.metadataListener);
        }
        channel.getContext().flushIO();
    }

    private String toStringDBR(DBR value) {
        StringBuilder builder = new StringBuilder();
        if (value == null) {
            return "null";
        }
        if (value.getValue() instanceof double[]) {
            builder.append(Arrays.toString((double[])value.getValue()));
        } else if (value.getValue() instanceof short[]) {
            builder.append(Arrays.toString((short[])value.getValue()));
        } else if (value.getValue() instanceof String[]) {
            builder.append(Arrays.toString((String[])value.getValue()));
        } else {
            builder.append(value.getValue().toString());
        }
        return builder.toString();
    }

    public synchronized void disconnect() {
        try {
            if (this.channel.getConnectionState() != Channel.ConnectionState.CLOSED) {
                this.channel.removeConnectionListener(this.connectionListener);
                this.channel.destroy();
            }
        }
        catch (CAException ex) {
            throw new RuntimeException("JCA Disconnect fail", ex);
        }
        finally {
            this.channel = null;
            this.sentReadOnlyException = false;
            this.processConnection(null);
        }
    }

    public void write(Object newValue, ChannelWriteCallback callback) {
        try {
            if (this.isPutCallback()) {
                this.putWithCallback(newValue, callback);
            } else {
                this.put(newValue, callback);
            }
        }
        catch (CAException ex) {
            callback.channelWritten((Exception)((Object)ex));
        }
    }

    protected boolean isConnected(JCAConnectionPayload connPayload) {
        return connPayload != null && connPayload.isChannelConnected();
    }

    protected boolean isWriteConnected(JCAConnectionPayload connPayload) {
        return connPayload != null && connPayload.isWriteConnected();
    }

    protected synchronized void addWriter(ChannelHandlerWriteSubscription subscription) {
        super.addWriter(subscription);
        if (this.sentReadOnlyException) {
            subscription.getExceptionWriteFunction().writeValue((Object)this.createReadOnlyException());
        }
    }

    private Exception createReadOnlyException() {
        return new RuntimeException("'" + this.getJcaChannelName() + "' is read-only");
    }

    public synchronized Map<String, Object> getProperties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (this.channel != null) {
            properties.put("CA Channel name", this.channel.getName());
            properties.put("CA Connection state", this.channel.getConnectionState().getName());
            if (this.channel.getConnectionState() == Channel.ConnectionState.CONNECTED) {
                properties.put("CA Hostname", this.channel.getHostName());
                properties.put("CA Channel type", this.channel.getFieldType().getName());
                properties.put("CA Element count", this.channel.getElementCount());
                properties.put("CA Read access", this.channel.getReadAccess());
                properties.put("CA Write access", this.channel.getWriteAccess());
            }
            properties.put("isLongString", this.isLongString());
            properties.put("isPutCallback", this.isPutCallback());
            properties.put("Connected", this.isConnected());
            properties.put("Write Connected", this.isWriteConnected());
            properties.put("Connection payload", this.getConnectionPayload());
            properties.put("Last message payload", this.getLastMessagePayload());
        }
        return properties;
    }

    protected DBRType metadataFor(Channel channel) {
        DBRType type = channel.getFieldType();
        if (type.isBYTE() || type.isSHORT() || type.isINT() || type.isFLOAT() || type.isDOUBLE()) {
            return DBR_CTRL_Double.TYPE;
        }
        if (type.isENUM()) {
            return DBR_LABELS_Enum.TYPE;
        }
        return null;
    }

    protected int countFor(Channel channel) {
        if (channel.getElementCount() == 1) {
            return 1;
        }
        if (this.jcaDataSource.isVarArraySupported()) {
            return 0;
        }
        return channel.getElementCount();
    }

    protected DBRType valueTypeFor(Channel channel) {
        DBRType type = channel.getFieldType();
        if (type.isBYTE()) {
            return DBR_TIME_Byte.TYPE;
        }
        if (type.isSHORT()) {
            return DBR_TIME_Short.TYPE;
        }
        if (type.isINT()) {
            return DBR_TIME_Int.TYPE;
        }
        if (type.isFLOAT()) {
            return DBR_TIME_Float.TYPE;
        }
        if (type.isDOUBLE()) {
            return DBR_TIME_Double.TYPE;
        }
        if (type.isENUM()) {
            return DBR_TIME_Enum.TYPE;
        }
        if (type.isSTRING()) {
            if (this.jcaDataSource.isRtypValueOnly() && rtypeStringPattern.matcher(channel.getName()).matches()) {
                return DBR_String.TYPE;
            }
            return DBR_TIME_String.TYPE;
        }
        throw new IllegalArgumentException("Unsupported type " + type);
    }

    static byte[] toBytes(String text) {
        byte[] bytes = new byte[text.length() + 1];
        System.arraycopy(text.getBytes(), 0, bytes, 0, text.length());
        bytes[text.length()] = 0;
        return bytes;
    }

    static String toString(byte[] data) {
        int index;
        for (index = 0; index < data.length && data[index] != 0; ++index) {
        }
        return new String(data, 0, index);
    }
}

