/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.jca;

import gov.aps.jca.dbr.DBR;
import gov.aps.jca.dbr.DBR_CTRL_Double;
import gov.aps.jca.dbr.DBR_LABELS_Enum;
import gov.aps.jca.dbr.DBR_TIME_Byte;
import gov.aps.jca.dbr.DBR_TIME_Double;
import gov.aps.jca.dbr.DBR_TIME_Enum;
import gov.aps.jca.dbr.DBR_TIME_Float;
import gov.aps.jca.dbr.DBR_TIME_Int;
import gov.aps.jca.dbr.DBR_TIME_Short;
import gov.aps.jca.dbr.DBR_TIME_String;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.epics.pvmanager.ValueCache;
import org.epics.pvmanager.jca.JCAConnectionPayload;
import org.epics.pvmanager.jca.JCATypeAdapter;
import org.epics.pvmanager.jca.JCATypeAdapterSet;
import org.epics.pvmanager.jca.VByteArrayFromDbr;
import org.epics.pvmanager.jca.VByteFromDbr;
import org.epics.pvmanager.jca.VDoubleArrayFromDbr;
import org.epics.pvmanager.jca.VDoubleFromDbr;
import org.epics.pvmanager.jca.VEnumFromDbr;
import org.epics.pvmanager.jca.VFloatArrayFromDbr;
import org.epics.pvmanager.jca.VFloatFromDbr;
import org.epics.pvmanager.jca.VIntArrayFromDbr;
import org.epics.pvmanager.jca.VIntFromDbr;
import org.epics.pvmanager.jca.VShortArrayFromDbr;
import org.epics.pvmanager.jca.VShortFromDbr;
import org.epics.pvmanager.jca.VStringArrayFromDbr;
import org.epics.pvmanager.jca.VStringFromDbr;
import org.epics.vtype.VByte;
import org.epics.vtype.VByteArray;
import org.epics.vtype.VDouble;
import org.epics.vtype.VDoubleArray;
import org.epics.vtype.VEnum;
import org.epics.vtype.VFloat;
import org.epics.vtype.VFloatArray;
import org.epics.vtype.VInt;
import org.epics.vtype.VIntArray;
import org.epics.vtype.VShort;
import org.epics.vtype.VShortArray;
import org.epics.vtype.VString;
import org.epics.vtype.VStringArray;

public class JCAVTypeAdapterSet
implements JCATypeAdapterSet {
    static final JCATypeAdapter DBRFloatToVFloat = new JCATypeAdapter((Class)VFloat.class, DBR_TIME_Float.TYPE, DBR_CTRL_Double.TYPE, (Boolean)false){

        public VFloat createValue(DBR value, DBR metadata, JCAConnectionPayload connPayload) {
            return new VFloatFromDbr((DBR_TIME_Float)value, (DBR_CTRL_Double)metadata, connPayload);
        }
    };
    static final JCATypeAdapter DBRDoubleToVDouble = new JCATypeAdapter((Class)VDouble.class, DBR_TIME_Double.TYPE, DBR_CTRL_Double.TYPE, (Boolean)false){

        public VDouble createValue(DBR value, DBR metadata, JCAConnectionPayload connPayload) {
            return new VDoubleFromDbr((DBR_TIME_Double)value, (DBR_CTRL_Double)metadata, connPayload);
        }
    };
    static final JCATypeAdapter DBRByteToVByte = new JCATypeAdapter((Class)VByte.class, DBR_TIME_Byte.TYPE, DBR_CTRL_Double.TYPE, (Boolean)false){

        public VByte createValue(DBR value, DBR metadata, JCAConnectionPayload connPayload) {
            return new VByteFromDbr((DBR_TIME_Byte)value, (DBR_CTRL_Double)metadata, connPayload);
        }
    };
    static final JCATypeAdapter DBRShortToVShort = new JCATypeAdapter((Class)VShort.class, DBR_TIME_Short.TYPE, DBR_CTRL_Double.TYPE, (Boolean)false){

        public VShort createValue(DBR value, DBR metadata, JCAConnectionPayload connPayload) {
            return new VShortFromDbr((DBR_TIME_Short)value, (DBR_CTRL_Double)metadata, connPayload);
        }
    };
    static final JCATypeAdapter DBRIntToVInt = new JCATypeAdapter((Class)VInt.class, DBR_TIME_Int.TYPE, DBR_CTRL_Double.TYPE, (Boolean)false){

        public VInt createValue(DBR value, DBR metadata, JCAConnectionPayload connPayload) {
            return new VIntFromDbr((DBR_TIME_Int)value, (DBR_CTRL_Double)metadata, connPayload);
        }
    };
    static final JCATypeAdapter DBRStringToVString = new JCATypeAdapter((Class)VString.class, DBR_TIME_String.TYPE, null, (Boolean)false){

        public VString createValue(DBR value, DBR metadata, JCAConnectionPayload connPayload) {
            return new VStringFromDbr((DBR_TIME_String)value, connPayload);
        }
    };
    static final JCATypeAdapter DBRByteToVString = new JCATypeAdapter((Class)VString.class, DBR_TIME_Byte.TYPE, null, null){

        @Override
        public int match(ValueCache<?> cache, JCAConnectionPayload connPayload) {
            if (!connPayload.isLongString()) {
                return 0;
            }
            return super.match(cache, connPayload);
        }

        public VString createValue(DBR value, DBR metadata, JCAConnectionPayload connPayload) {
            return new VStringFromDbr((DBR_TIME_Byte)value, connPayload);
        }
    };
    static final JCATypeAdapter DBREnumToVEnum = new JCATypeAdapter((Class)VEnum.class, DBR_TIME_Enum.TYPE, DBR_LABELS_Enum.TYPE, (Boolean)false){

        public VEnum createValue(DBR value, DBR metadata, JCAConnectionPayload connPayload) {
            return new VEnumFromDbr((DBR_TIME_Enum)value, (DBR_LABELS_Enum)metadata, connPayload);
        }
    };
    static final JCATypeAdapter DBRFloatToVFloatArray = new JCATypeAdapter((Class)VFloatArray.class, DBR_TIME_Float.TYPE, DBR_CTRL_Double.TYPE, (Boolean)true){

        public VFloatArray createValue(DBR value, DBR metadata, JCAConnectionPayload connPayload) {
            return new VFloatArrayFromDbr((DBR_TIME_Float)value, (DBR_CTRL_Double)metadata, connPayload);
        }
    };
    static final JCATypeAdapter DBRDoubleToVDoubleArray = new JCATypeAdapter((Class)VDoubleArray.class, DBR_TIME_Double.TYPE, DBR_CTRL_Double.TYPE, (Boolean)true){

        public VDoubleArray createValue(DBR value, DBR metadata, JCAConnectionPayload connPayload) {
            return new VDoubleArrayFromDbr((DBR_TIME_Double)value, (DBR_CTRL_Double)metadata, connPayload);
        }
    };
    static final JCATypeAdapter DBRByteToVByteArray = new JCATypeAdapter((Class)VByteArray.class, DBR_TIME_Byte.TYPE, DBR_CTRL_Double.TYPE, (Boolean)true){

        @Override
        public int match(ValueCache<?> cache, JCAConnectionPayload connPayload) {
            if (connPayload.isLongString()) {
                return 0;
            }
            return super.match(cache, connPayload);
        }

        public VByteArray createValue(DBR value, DBR metadata, JCAConnectionPayload connPayload) {
            return new VByteArrayFromDbr((DBR_TIME_Byte)value, (DBR_CTRL_Double)metadata, connPayload);
        }
    };
    static final JCATypeAdapter DBRShortToVShortArray = new JCATypeAdapter((Class)VShortArray.class, DBR_TIME_Short.TYPE, DBR_CTRL_Double.TYPE, (Boolean)true){

        public VShortArray createValue(DBR value, DBR metadata, JCAConnectionPayload connPayload) {
            return new VShortArrayFromDbr((DBR_TIME_Short)value, (DBR_CTRL_Double)metadata, connPayload);
        }
    };
    static final JCATypeAdapter DBRIntToVIntArray = new JCATypeAdapter((Class)VIntArray.class, DBR_TIME_Int.TYPE, DBR_CTRL_Double.TYPE, (Boolean)true){

        public VIntArray createValue(DBR value, DBR metadata, JCAConnectionPayload connPayload) {
            return new VIntArrayFromDbr((DBR_TIME_Int)value, (DBR_CTRL_Double)metadata, connPayload);
        }
    };
    static final JCATypeAdapter DBRStringToVStringArray = new JCATypeAdapter((Class)VStringArray.class, DBR_TIME_String.TYPE, null, (Boolean)true){

        public VStringArray createValue(DBR value, DBR metadata, JCAConnectionPayload connPayload) {
            return new VStringArrayFromDbr((DBR_TIME_String)value, connPayload);
        }
    };
    private static final Set<JCATypeAdapter> converters;

    public Set<JCATypeAdapter> getAdapters() {
        return converters;
    }

    static {
        HashSet<JCATypeAdapter> newFactories = new HashSet<JCATypeAdapter>();
        newFactories.add(DBRFloatToVFloat);
        newFactories.add(DBRDoubleToVDouble);
        newFactories.add(DBRByteToVByte);
        newFactories.add(DBRShortToVShort);
        newFactories.add(DBRIntToVInt);
        newFactories.add(DBRStringToVString);
        newFactories.add(DBRByteToVString);
        newFactories.add(DBREnumToVEnum);
        newFactories.add(DBRFloatToVFloatArray);
        newFactories.add(DBRDoubleToVDoubleArray);
        newFactories.add(DBRByteToVByteArray);
        newFactories.add(DBRShortToVShortArray);
        newFactories.add(DBRIntToVIntArray);
        newFactories.add(DBRStringToVStringArray);
        converters = Collections.unmodifiableSet(newFactories);
    }
}

