/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.jca;

import gov.aps.jca.dbr.TIME;
import org.epics.pvmanager.jca.DataUtils;
import org.epics.pvmanager.jca.JCAConnectionPayload;
import org.epics.util.time.Timestamp;
import org.epics.vtype.Alarm;
import org.epics.vtype.AlarmSeverity;
import org.epics.vtype.Time;

class VMetadata<TValue extends TIME>
implements Alarm,
Time {
    final TValue dbrValue;
    private final boolean disconnected;
    private final Timestamp timestamp;

    VMetadata(TValue dbrValue, JCAConnectionPayload connPayload) {
        this.dbrValue = dbrValue;
        this.disconnected = !connPayload.isChannelConnected();
        this.timestamp = this.disconnected ? connPayload.getEventTime() : DataUtils.timestampOf(dbrValue.getTimeStamp());
    }

    public AlarmSeverity getAlarmSeverity() {
        if (this.disconnected) {
            return AlarmSeverity.UNDEFINED;
        }
        return DataUtils.fromEpics(this.dbrValue.getSeverity());
    }

    public String getAlarmName() {
        if (this.disconnected) {
            return "Disconnected";
        }
        return this.dbrValue.getStatus().getName();
    }

    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    public Integer getTimeUserTag() {
        return null;
    }

    public boolean isTimeValid() {
        return DataUtils.isTimeValid(this.dbrValue.getTimeStamp());
    }
}

