/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.jca;

import gov.aps.jca.Channel;
import gov.aps.jca.dbr.DBR;
import gov.aps.jca.dbr.DBRType;
import org.epics.pvmanager.DataSourceTypeAdapter;
import org.epics.pvmanager.ValueCache;
import org.epics.pvmanager.jca.JCAConnectionPayload;
import org.epics.pvmanager.jca.JCAMessagePayload;

public abstract class JCATypeAdapter
implements DataSourceTypeAdapter<JCAConnectionPayload, JCAMessagePayload> {
    private final Class<?> typeClass;
    private final DBRType epicsValueType;
    private final DBRType epicsMetaType;
    private final Boolean array;

    public JCATypeAdapter(Class<?> typeClass, DBRType epicsValueType, DBRType epicsMetaType, Boolean array) {
        this.typeClass = typeClass;
        this.epicsValueType = epicsValueType;
        this.epicsMetaType = epicsMetaType;
        this.array = array;
    }

    public int match(ValueCache<?> cache, JCAConnectionPayload connPayload) {
        Channel channel = connPayload.getChannel();
        if (!cache.getType().isAssignableFrom(this.typeClass)) {
            return 0;
        }
        if (!JCATypeAdapter.dbrTypeMatch(this.epicsValueType, connPayload.getFieldType())) {
            return 0;
        }
        if (this.array != null && this.array.booleanValue() && channel.getElementCount() == 1) {
            return 0;
        }
        if (this.array != null && !this.array.booleanValue() && channel.getElementCount() != 1) {
            return 0;
        }
        return 1;
    }

    private static boolean dbrTypeMatch(DBRType aType, DBRType anotherType) {
        if (aType.getClass() == null && anotherType.getClass() != null) {
            return false;
        }
        if (aType.getClass() != null && anotherType.getClass() == null) {
            return false;
        }
        return aType.isBYTE() && anotherType.isBYTE() || aType.isDOUBLE() && anotherType.isDOUBLE() || aType.isENUM() && anotherType.isENUM() || aType.isFLOAT() && anotherType.isFLOAT() || aType.isINT() && anotherType.isINT() || aType.isSHORT() && anotherType.isSHORT() || aType.isSTRING() && anotherType.isSTRING();
    }

    public Object getSubscriptionParameter(ValueCache cache, JCAConnectionPayload connPayload) {
        throw new UnsupportedOperationException("Not implemented: JCAChannelHandler is multiplexed, will not use this method");
    }

    public boolean updateCache(ValueCache cache, JCAConnectionPayload connPayload, JCAMessagePayload message) {
        Channel channel = connPayload.getChannel();
        if (this.epicsMetaType != null && message.getMetadata() == null) {
            return false;
        }
        if (message.getEvent() == null) {
            return false;
        }
        Object value = this.createValue(message.getEvent().getDBR(), message.getMetadata(), connPayload);
        cache.writeValue(value);
        return true;
    }

    public abstract Object createValue(DBR var1, DBR var2, JCAConnectionPayload var3);
}

