/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.sys;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.epics.pvmanager.ChannelWriteCallback;
import org.epics.pvmanager.MultiplexedChannelHandler;
import org.epics.pvmanager.sys.SystemDataSource;
import org.epics.util.text.NumberFormats;
import org.epics.vtype.Display;
import org.epics.vtype.DisplayBuilder;

abstract class SystemChannelHandler
extends MultiplexedChannelHandler<Object, Object> {
    protected static Display memoryDisplay = new DisplayBuilder().format(NumberFormats.format((int)3)).units("MiB").lowerAlarmLimit(Double.valueOf(0.0)).lowerCtrlLimit(Double.valueOf(0.0)).lowerDisplayLimit(Double.valueOf(0.0)).lowerWarningLimit(Double.valueOf(0.0)).upperAlarmLimit(Double.valueOf(SystemChannelHandler.maxMemory())).upperCtrlLimit(Double.valueOf(SystemChannelHandler.maxMemory())).upperDisplayLimit(Double.valueOf(SystemChannelHandler.maxMemory())).upperWarningLimit(Double.valueOf(SystemChannelHandler.maxMemory())).build();
    private final Runnable task = new Runnable(){

        @Override
        public void run() {
            try {
                Object newValue = SystemChannelHandler.this.createValue();
                if (newValue != null) {
                    SystemChannelHandler.this.processMessage(newValue);
                }
            }
            catch (Exception ex) {
                log.log(Level.WARNING, "Data simulation problem", ex);
            }
        }
    };
    private static final Logger log = Logger.getLogger(SystemChannelHandler.class.getName());
    private ScheduledFuture<?> taskFuture;

    protected static double bytesToMebiByte(long bytes) {
        return (double)bytes / 1048576.0;
    }

    private static double maxMemory() {
        return SystemChannelHandler.bytesToMebiByte(Runtime.getRuntime().maxMemory());
    }

    protected abstract Object createValue();

    public SystemChannelHandler(String channelName) {
        super(channelName);
    }

    public void connect() {
        this.taskFuture = SystemDataSource.getScheduledExecutorService().scheduleWithFixedDelay(this.task, 0L, 1L, TimeUnit.SECONDS);
        this.processConnection(new Object());
    }

    public void disconnect() {
        this.taskFuture.cancel(false);
        this.taskFuture = null;
        this.processConnection(null);
    }

    public void write(Object newValue, ChannelWriteCallback callback) {
        throw new UnsupportedOperationException("Can't write to system channel.");
    }

    public boolean isConnected(Object connection) {
        return this.taskFuture != null;
    }

    protected boolean saveMessageAfterDisconnect() {
        return true;
    }
}

