/*
 * Decompiled with CFR 0.152.
 */
package org.epics.pvmanager.sys;

import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Logger;
import org.epics.pvmanager.ChannelHandler;
import org.epics.pvmanager.DataSource;
import org.epics.pvmanager.sys.FreeMemoryChannelHandler;
import org.epics.pvmanager.sys.HostnameChannelHandler;
import org.epics.pvmanager.sys.MaxMemoryChannelHandler;
import org.epics.pvmanager.sys.QualifiedHostnameChannelHandler;
import org.epics.pvmanager.sys.SystemPropertyChannelHandler;
import org.epics.pvmanager.sys.TimeChannelHandler;
import org.epics.pvmanager.sys.UsedMemoryChannelHandler;
import org.epics.pvmanager.sys.UserChannelHandler;
import org.epics.pvmanager.util.Executors;
import org.epics.pvmanager.vtype.DataTypeSupport;

public final class SystemDataSource
extends DataSource {
    private static final Logger log;
    private static ScheduledExecutorService exec;

    public SystemDataSource() {
        super(false);
    }

    static ScheduledExecutorService getScheduledExecutorService() {
        return exec;
    }

    protected ChannelHandler createChannel(String channelName) {
        if ("free_mb".equals(channelName)) {
            return new FreeMemoryChannelHandler(channelName);
        }
        if ("max_mb".equals(channelName)) {
            return new MaxMemoryChannelHandler(channelName);
        }
        if ("used_mb".equals(channelName)) {
            return new UsedMemoryChannelHandler(channelName);
        }
        if ("time".equals(channelName)) {
            return new TimeChannelHandler(channelName);
        }
        if ("user".equals(channelName)) {
            return new UserChannelHandler(channelName);
        }
        if ("host_name".equals(channelName)) {
            return new HostnameChannelHandler(channelName);
        }
        if ("qualified_host_name".equals(channelName)) {
            return new QualifiedHostnameChannelHandler(channelName);
        }
        if (channelName.startsWith("system.")) {
            return new SystemPropertyChannelHandler(channelName);
        }
        throw new IllegalArgumentException("Channel " + channelName + " does not exist");
    }

    static {
        DataTypeSupport.install();
        log = Logger.getLogger(SystemDataSource.class.getName());
        exec = java.util.concurrent.Executors.newSingleThreadScheduledExecutor(Executors.namedPool((String)"pvmanager-sys poller "));
    }
}

